//---------------------------------------------------------------------------

#include <vcl.h>
#include <stdio.h>
#include <registry.hpp>
#include <io.h>
#include <string>
#include <ctype.h>

#pragma hdrstop

#include "main.h"
#include "crc.h"
#include "utf.h"
#include "flhash.h"
//---------------------------------------------------------------------------
#pragma package(smart_init)
#pragma link "LMDBaseDialog"
#pragma link "LMDContainerComponent"
#pragma link "LMDCustomComponent"
#pragma link "LMDDirDlg"
#pragma link "LMDBaseEdit"
#pragma link "LMDCustomBevelPanel"
#pragma link "LMDCustomControl"
#pragma link "LMDCustomEdit"
#pragma link "LMDCustomMaskEdit"
#pragma link "LMDCustomPanel"
#pragma link "LMDMaskEdit"
#pragma resource "*.dfm"
TMainForm *MainForm;

THashLookupEntry lookup_entry;
FILE *dump_file;
//---------------------------------------------------------------------------
__fastcall TMainForm::TMainForm(TComponent* Owner)
    : TForm(Owner)
{
}
//---------------------------------------------------------------------------
void __fastcall TMainForm::FormCreate(TObject *Sender)
{
    // Fill in the FL dir from registry
    TRegistry *my_registry = new TRegistry();
    const String reg_key = "\\Software\\Microsoft\\Microsoft Games\\Freelancer\\1.0";
    AnsiString path;

    my_registry->RootKey = HKEY_LOCAL_MACHINE;

    try {
        if(my_registry->OpenKey(reg_key, false)) {
            path = my_registry->ReadString("AppPath");

            if(!path.IsEmpty()) {
                path += "\\Data";
                FLDirEdit->Text = path;
            }
            else
                ShowMessage("Error : Path not found");

            my_registry->CloseKey();
        }
    }
    catch(ERegistryException &E) {
    	ShowMessage(E.Message);
        delete my_registry;
        return;
    }

    delete my_registry;

    if(FileExists(ExtractFilePath(Application->ExeName) + "tmp.cdb"))
        DBSearchFileEdit->Text = ExtractFilePath(Application->ExeName) + "tmp.cdb";
}
//---------------------------------------------------------------------------
void RecurseDirectories(AnsiString path) {
	struct _finddata_t data;
	AnsiString fname = path + "\\*.*";
    AnsiString tmp;

	// initialize the search functions
	long handle = _findfirst(fname.c_str(), &data);
	if(handle >= 0) {
		do {
			// ignore . and .. directories.
            tmp = data.name ;
			if((strcmp(tmp.c_str(), ".") != 0) && (strcmp(tmp.c_str(), "..") != 0)) {
                if(DirectoryExists(path + "\\" + data.name)) {
					// found a directory
                    fname = path + "\\" + data.name;
					RecurseDirectories(fname);
				}
				else if((ExtractFileExt(data.name) == ".ini") ||
                                (ExtractFileExt(data.name) == ".cmp") ||
                                (ExtractFileExt(data.name) == ".3db") ||
                                (ExtractFileExt(data.name) == ".mat") ||
                                (ExtractFileExt(data.name) == ".utf"))
					// not a sub-directory, so print the file name
                    file_list->Add(path + "\\" + data.name);
			}
		} while( _findnext(handle,&data) == 0);
		// close the file search handle
		_findclose(handle);
	}
}
//---------------------------------------------------------------------------
void ScanUTF(AnsiString filename) {
    CNameCRC *NameCRC = new CNameCRC;
    TFileStream *utf_file = new TFileStream(filename, fmOpenRead, fmShareExclusive);
    TUTFHeader utf_header;
    char tmp[255];

    utf_file->Read(&utf_header, sizeof(TUTFHeader));
    utf_file->Seek(utf_header.string_seg_offset, soFromBeginning);

    MainForm->CurrentValueLabel->Caption = filename;
    Application->HandleMessage();
    MainForm->Repaint();

    unsigned int c = 0;  // loop count
    int i = 0; // string index
    while(c < utf_header.string_seg_space_used) {
        utf_file->Read(&tmp[i], sizeof(char));
        if(tmp[i++] == '\0') {
            if(strstr(tmp, ".vms") || strstr(tmp, ".3db") || strstr(tmp, ".tga")
                                   || strstr(tmp, ".TGA")) {

                strcpy(lookup_entry.crc_name, tmp);
                lookup_entry.crc_name_length = strlen(tmp) + 1;
                lookup_entry.crc_value = NameCRC->GenerateCRC(tmp);
                lookup_entry.hash_value = flhash(lookup_entry.crc_name, lookup_entry.crc_name_length);
                strcpy(lookup_entry.from_file, filename.c_str());
                lookup_entry.from_file_length = filename.Length() + 1;

                temp_db_file->Write(&lookup_entry.crc_value, sizeof(int));
                temp_db_file->Write(&lookup_entry.hash_value, sizeof(int));
                temp_db_file->Write(&lookup_entry.crc_name_length, sizeof(int));
                temp_db_file->Write(tmp, lookup_entry.crc_name_length);
                temp_db_file->Write(&lookup_entry.from_file_length, sizeof(int));
                temp_db_file->Write(&lookup_entry.from_file, lookup_entry.from_file_length);

                fprintf(dump_file, "%s\n%s\n0x%08x\t\t%u\n", lookup_entry.crc_name, lookup_entry.from_file, lookup_entry.crc_value, lookup_entry.hash_value);
            }

            // handle the sound files whose name is the string of the hash value
            if((strstr(tmp, "0x")) && (strlen(tmp) == 10)) {
                strcpy(lookup_entry.crc_name, tmp);
                lookup_entry.crc_name_length = strlen(tmp) + 1;
                lookup_entry.crc_value = NameCRC->GenerateCRC(tmp);
                AnsiString hash = tmp;
                lookup_entry.hash_value = hash.ToInt();
                strcpy(lookup_entry.from_file, filename.c_str());
                lookup_entry.from_file_length = filename.Length() + 1;

                temp_db_file->Write(&lookup_entry.crc_value, sizeof(int));
                temp_db_file->Write(&lookup_entry.hash_value, sizeof(int));
                temp_db_file->Write(&lookup_entry.crc_name_length, sizeof(int));
                temp_db_file->Write(tmp, lookup_entry.crc_name_length);
                temp_db_file->Write(&lookup_entry.from_file_length, sizeof(int));
                temp_db_file->Write(&lookup_entry.from_file, lookup_entry.from_file_length);

                fprintf(dump_file, "%s\n%s\n0x%08x\t\t%u\n", lookup_entry.crc_name, lookup_entry.from_file, lookup_entry.crc_value, lookup_entry.hash_value);
            }

            c += i;
            i = 0;
        }
    }

    delete utf_file;
    delete NameCRC;
}
//---------------------------------------------------------------------------
void ScanINI(AnsiString filename) {
    CNameCRC *NameCRC = new CNameCRC;
    TStringList *ini_file = new TStringList;

    char tmp[2048];
    char tmp2[255];

    ini_file->LoadFromFile(filename);

    MainForm->CurrentValueLabel->Caption = filename;
    Application->HandleMessage();
    MainForm->Repaint();

    // read each line
    for(int i = 0; i < ini_file->Count; ++i) {
        // search for each ident string listed
        for(int j = 0; j < MainForm->SearchStringMemo->Lines->Count; ++j) {
            if(MainForm->SearchStringMemo->Lines->Strings[j].Length() == 0) break;

            if(strstr(ini_file->Strings[i].c_str(), MainForm->SearchStringMemo->Lines->Strings[j].c_str())) {
                // found one
                strcpy(tmp, ini_file->Strings[i].c_str());
                int p = 0;

                // skip section names if have same name as an ident we want
                if(tmp[p] == '[') break;

                // strip the value
                for(int c = MainForm->SearchStringMemo->Lines->Strings[j].Length() + 1; c < ini_file->Strings[i].Length(); ++c) {
                    if(isgraph(tmp[c]) && ((char)tmp[c] != '=') && (tmp[c] != ';'))
                        tmp2[p++] = tmp[c];
                }

                tmp2[p] = '\0';

                // add it to the db
                strcpy(lookup_entry.crc_name, tmp2);
                lookup_entry.crc_name_length = strlen(lookup_entry.crc_name) + 1;
                lookup_entry.crc_value = NameCRC->GenerateCRC(lookup_entry.crc_name);
                lookup_entry.hash_value = flhash(lookup_entry.crc_name, strlen(lookup_entry.crc_name));
                strcpy(lookup_entry.from_file, filename.c_str());
                lookup_entry.from_file_length = filename.Length() + 1;

                temp_db_file->Write(&lookup_entry.crc_value, sizeof(int));
                temp_db_file->Write(&lookup_entry.hash_value, sizeof(int));
                temp_db_file->Write(&lookup_entry.crc_name_length, sizeof(int));
                temp_db_file->Write(lookup_entry.crc_name, lookup_entry.crc_name_length);
                temp_db_file->Write(&lookup_entry.from_file_length, sizeof(int));
                temp_db_file->Write(&lookup_entry.from_file, lookup_entry.from_file_length);

                fprintf(dump_file, "%s\n%s\n0x%08x\t\t%u\n", lookup_entry.crc_name, lookup_entry.from_file, lookup_entry.crc_value, lookup_entry.hash_value);

                // don't search for other values in this line
                break;
            }
        }
    }

    delete NameCRC;
}
//---------------------------------------------------------------------------
void __fastcall TMainForm::CreateDBButtonClick(TObject *Sender)
{
    TControl *child_control;
    file_list = new TStringList;
    temp_db_file = new TFileStream(ExtractFilePath(Application->ExeName) + "tmp.cdb", fmCreate, fmShareExclusive);
    dump_file = NULL;

    AnsiString txt_file = ExtractFilePath(Application->ExeName) + "tmp.txt";

    dump_file = fopen(txt_file.c_str(), "w+");

    // Search the ini files for variables listed
    CurrentValueLabel->Caption = "Building file list...";

    // titles for text dump
    fprintf(dump_file, "Format :\n\nname\nfound in file\nUTF id (hex)\t\tHash Code (dec)\n\n");

    for(int i = 0; i < MainForm->ControlCount; ++i) {
        child_control = MainForm->Controls[i];
        if(child_control->Name != "CurrentValueLabel")
            child_control->Enabled = false;
    }

    MainForm->Repaint();
    RecurseDirectories(FLDirEdit->Text);

    ScanningProgressBar->Max = file_list->Count;

    Application->HandleMessage();

    // open each file in turn and search for appropriate stuff
    for(int i = 0; i < file_list->Count; ++i) {
        // ini or model file?
        if(ExtractFileExt(file_list->Strings[i]) == ".ini")
            ScanINI(file_list->Strings[i]);
        else
            ScanUTF(file_list->Strings[i]);

        ScanningProgressBar->Position +=1;
    }

    DBSearchFileEdit->Text = ExtractFilePath(Application->ExeName) + "tmp.cdb";
    CurrentValueLabel->Caption = "Done!";
    ScanningProgressBar->Position = 0;

    for(int i = 0; i < MainForm->ControlCount; ++i) {
        child_control = MainForm->Controls[i];
        if(child_control->Name != "CurrentValueLabel")
            child_control->Enabled = true;
    }

    Beep();

    fclose(dump_file);
    delete temp_db_file;
}
//---------------------------------------------------------------------------

void __fastcall TMainForm::DBSearchButtonClick(TObject *Sender)
{
    TFileStream *db_file;
    unsigned long crc;
    bool found = false;
    AnsiString from_file;

    ResultMemo->Lines->Clear();

    if(HexSearchRadioButton->Checked)
        crc = HexCRCEdit->Text.ToInt();
    else
        crc = (int)DecCRCEdit->Text.ToDouble();

    db_file = new TFileStream(DBSearchFileEdit->Text, fmOpenRead, fmShareExclusive);

    while(db_file->Position < db_file->Size) {
        db_file->Read(&lookup_entry.crc_value, sizeof(int));
        db_file->Read(&lookup_entry.hash_value, sizeof(int));
        db_file->Read(&lookup_entry.crc_name_length, sizeof(int));
        db_file->Read(&lookup_entry.crc_name, lookup_entry.crc_name_length);
        db_file->Read(&lookup_entry.from_file_length, sizeof(int));
        db_file->Read(&lookup_entry.from_file, lookup_entry.from_file_length);

        from_file = lookup_entry.from_file;

        if(crc == lookup_entry.crc_value) {
            found = true;
            ResultMemo->Lines->Add(lookup_entry.crc_name);
            ResultMemo->Lines->Add("(" + from_file + ")");
        }

        if(crc == lookup_entry.hash_value) {
            found = true;
            ResultMemo->Lines->Add(lookup_entry.crc_name);
            ResultMemo->Lines->Add("(" + from_file + ")");
        }
    }

    if(!found) ResultMemo->Lines->Add("Not found.");

    delete db_file;
}
//---------------------------------------------------------------------------

void __fastcall TMainForm::CRCGenerateButtonClick(TObject *Sender)
{
    // generate a crc
    CNameCRC *NameCRC = new CNameCRC;

    ConvertDecResultEdit->Text = NameCRC->GenerateCRC(ConvertNameEdit->Text);
    ConvertHexResultEdit->Text = IntToHex((int)ConvertDecResultEdit->Text.ToDouble(), 4);

    ConvertHashDecEdit->Text = flhash(ConvertNameEdit->Text.c_str(), ConvertNameEdit->Text.Length());
    ConvertHashHexEdit->Text = IntToHex((int)ConvertHashDecEdit->Text.ToDouble(), 4);

    delete NameCRC;
}
//---------------------------------------------------------------------------

void __fastcall TMainForm::FLDataDirButtonClick(TObject *Sender)
{
    DirectoryDialog->InitialDir = FLDirEdit->Text;
    if(DirectoryDialog->Execute())
        FLDirEdit->Text = DirectoryDialog->Path;
}
//---------------------------------------------------------------------------

void __fastcall TMainForm::DBSearchFileButtonClick(TObject *Sender)
{
    FileDialog->InitialDir = ExtractFilePath(Application->ExeName);
    if(FileDialog->Execute())
        DBSearchFileEdit->Text = FileDialog->FileName;
}
//---------------------------------------------------------------------------

void __fastcall TMainForm::ConvertNameEditKeyPress(TObject *Sender,
      char &Key)
{
    if((unsigned char)Key == 13)
        CRCGenerateButtonClick(Sender);
}
//---------------------------------------------------------------------------

void __fastcall TMainForm::SaveDBButtonClick(TObject *Sender)
{
    AnsiString temp_file = ExtractFilePath(Application->ExeName) + "tmp.cdb";

    SaveDialog->InitialDir = ExtractFilePath(Application->ExeName);
    if(SaveDialog->Execute())
        CopyFile(temp_file.c_str(), SaveDialog->FileName.c_str(), false);
}
//---------------------------------------------------------------------------


void __fastcall TMainForm::SaveDBTextButtonClick(TObject *Sender)
{
    AnsiString temp_file = ExtractFilePath(Application->ExeName) + "tmp.txt";

    SaveDialog->InitialDir = ExtractFilePath(Application->ExeName);
    if(SaveDialog->Execute())
        CopyFile(temp_file.c_str(), SaveDialog->FileName.c_str(), false);
}
//---------------------------------------------------------------------------

