<?xml version="1.0" ?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" >
<xsl:preserve-space elements="language" />
<xsl:variable name="changes" select="/root/show_changes" />


<xsl:template match="/root">
	<html>
	<head>
	<style type="text/css">
	 	a:link { text-decoration:underline; font-weight:bold; color:darkblue; }
	 	a:visited { text-decoration:underline; font-weight:bold; color:darkblue; }
	 	a:hover { text-decoration:none; font-weight:bold; background-color:#FFFF00; }
	 	a:active { text-decoration:underline; font-weight:bold; color:darkblue; }
	</style>


	<title><xsl:value-of select="/language/template_title"/></title>
	</head>
	<body style="color:darkblue;background-color:gray;font-weight:lighter">
	
	<div style="color:darkblue;background-color:darkgray;margin-left:5px;font-weight:bold;font-size:13pt">
	
	<xsl:for-each select="language">
		<xsl:sort select="language" order="ascending" data-type="text" />
		<xsl:variable name="langnr"><xsl:number level="single" count="language" format="1." /></xsl:variable>
		<u><b><a style="margin-left:5px;"> <xsl:attribute name="name"><xsl:value-of select="template_language"/></xsl:attribute><xsl:value-of select="template_language"/> </a></b></u><br/><br/>
		<div style="color:black;font-size:11pt">
		<xsl:for-each select="scripts/addon">
			<xsl:sort select="name" order="ascending" data-type="text" />
			<xsl:variable name="mainnr"><xsl:number level="single" count="addon" format="1." /></xsl:variable>
			<a style="margin-left:20px;"><xsl:attribute name="name"><xsl:value-of select="$langnr" />_<xsl:value-of select="$mainnr" />_back</xsl:attribute><xsl:attribute name="href">#<xsl:value-of select="$langnr" />_<xsl:value-of select="$mainnr"/></xsl:attribute> <xsl:value-of select="name"/></a> <br/>
			<xsl:for-each select="main/point"> 
				<xsl:if test="/root/show_changes = 1">
					<xsl:if test="./description/changes">
					<div style="margin-left:40px;font-weight:lighter;"><xsl:variable name="subnr"><xsl:number level="single" count="point" format="1." /></xsl:variable>
					<a style="color:black;font-size:9pt"><xsl:attribute name="href">#<xsl:value-of select="$langnr"/>_<xsl:value-of select="$mainnr"/>_<xsl:value-of select="$subnr"/></xsl:attribute><xsl:value-of select="$subnr"/><xsl:value-of select="headline"/></a> <br/>
					</div>
					</xsl:if>
				</xsl:if>
				<xsl:if test="/root/show_changes = 0">
					<div style="margin-left:40px;font-weight:lighter;"><xsl:variable name="subnr"><xsl:number level="single" count="point" format="1." /></xsl:variable>
					<a style="color:black;font-size:9pt"><xsl:attribute name="href">#<xsl:value-of select="$langnr"/>_<xsl:value-of select="$mainnr"/>_<xsl:value-of select="$subnr"/></xsl:attribute><xsl:value-of select="$subnr"/><xsl:value-of select="headline"/></a> <br/>
					</div>
				</xsl:if>
			</xsl:for-each>
			<br />
		</xsl:for-each>
		</div>
	</xsl:for-each>
	</div>
	<hr/>
	<xsl:for-each select="language">
		<xsl:sort select="language" order="ascending" data-type="text" />
		<span style="color:white;font-size:40pt;text-decoration:underline;text-align:center"><xsl:value-of select="template_language"/></span><br/>
		<xsl:variable name="langnr2"><xsl:number level="single" count="language" format="1." /></xsl:variable>
		<xsl:for-each select="scripts/addon">
			<xsl:sort select="name" order="ascending" data-type="text" />
			<div style="padding:20px; border:thin solid darkblue;">
			<xsl:variable name="mainnr2"><xsl:number level="single" count="addon" format="1." /></xsl:variable>
			<br/><a style="margin-left:5px;"> <xsl:attribute name="name"><xsl:value-of select="$langnr2"/>_<xsl:value-of select="$mainnr2"/></xsl:attribute></a><span style="color:white;background-color:gray;font-size:18pt"><xsl:value-of select="name"/></span><br/>
			<table style="color:black;background-color:darkgray;font-size:11pt">
				<tr><th align="right"><xsl:value-of select="../../template_name"/></th><th align="left"><font color="black"><xsl:value-of select="name"/></font> </th></tr>
				<tr><th align="right"><xsl:value-of select="../../template_version"/></th><th align="left"><font color="black"><xsl:value-of select="version"/></font></th></tr>
				<tr><th align="right"><xsl:value-of select="../../template_date"/></th><th align="left"><font color="black"><xsl:value-of select="date"/> </font></th></tr>
			</table>
			<div style="color:white;background-color:gray;font-size:12pt">
			<br/><a style="margin-left:5px;"><xsl:value-of select="/language/template_description"/></a>
	    	<xsl:for-each select="main/point">
				<xsl:if test="/root/show_changes = 1">
					<xsl:if test="./description/changes">
						<table cellpadding="10" style="width:95%;color:black;background-color:darkgray;font-size:11pt">
  							<xsl:variable name="subnr2"><xsl:number level="single" count="point" format="1." /></xsl:variable>
   							<tr><th style="width:18%;color:darkblue;background-color:darkgray;font-size:11pt" align="right" valign="top"><a><xsl:attribute name="name"><xsl:value-of select="$langnr2" />_<xsl:value-of select="$mainnr2" />_<xsl:value-of select="$subnr2"/></xsl:attribute> <xsl:value-of select="headline"/></a>				
							</th><th style="width:82%;font-weight:normal;" align="left" valign="top"><xsl:apply-templates select="description" /><br /><br /></th></tr>			
						</table>
						<div style="text-align:center;font-size:9pt;font-weight:normal">
							<a><xsl:attribute name="href">#<xsl:value-of select="$langnr2" />_<xsl:value-of select="$mainnr2" />_back</xsl:attribute><xsl:value-of select="../../../../template_back"/></a>
						</div>
					</xsl:if>
				</xsl:if>
				<xsl:if test="/root/show_changes = 0">
					<table cellpadding="10" style="width:95%;color:black;background-color:darkgray;font-size:11pt">
  						<xsl:variable name="subnr2"><xsl:number level="single" count="point" format="1." /></xsl:variable>
   						<tr><th style="width:18%;color:darkblue;background-color:darkgray;font-size:11pt" align="right" valign="top"><a><xsl:attribute name="name"><xsl:value-of select="$langnr2" />_<xsl:value-of select="$mainnr2" />_<xsl:value-of select="$subnr2"/></xsl:attribute> <xsl:value-of select="headline"/></a>				
						</th><th style="width:82%;font-weight:normal;" align="left" valign="top"><xsl:apply-templates select="description" /><br /><br /></th></tr>			
					</table>
					<div style="text-align:center;font-size:9pt;font-weight:normal">
						<a><xsl:attribute name="href">#<xsl:value-of select="$langnr2" />_<xsl:value-of select="$mainnr2" />_back</xsl:attribute><xsl:value-of select="../../../../template_back"/></a>
					</div>
				</xsl:if>
	    	</xsl:for-each>
			<br/>
			<table style="font-size:9pt;color:black;background-color:darkgray;">
				<tr><th align="right"><xsl:value-of select="../../template_scripter"/></th><th align="left"><font color="black"><xsl:value-of select="scripter"/></font></th></tr>
				<xsl:variable name="wert1" select="contact" />
 				<xsl:choose>
  					<xsl:when test="$wert1 != ''">
						<tr><th align="right"><xsl:value-of select="../../template_contact"/></th><th align="left"><a><xsl:attribute name="href">mailto:<xsl:value-of select="contact"/></xsl:attribute><xsl:value-of select="contact"/></a></th></tr>
					</xsl:when>
 				</xsl:choose>
				<xsl:variable name="wert" select="translator" />
 				<xsl:choose>
  					<xsl:when test="$wert != ''">
					<tr><th align="right"><xsl:value-of select="../../template_translator"/></th><th align="left"><font color="black"><xsl:value-of select="translator"/> </font></th></tr>  		
					</xsl:when>
 				</xsl:choose>
			</table>
			</div>
			</div>
			<br/>
			<a><xsl:attribute name="href">#<xsl:value-of select="../../template_language"/></xsl:attribute> <xsl:value-of select="../../template_start"/></a> <br/>
			<hr/><hr/>
		</xsl:for-each>
	</xsl:for-each>
	</body>
	</html>
</xsl:template>

<xsl:template match="/root/language/scripts/addon/main/point/description/changes">
	<xsl:apply-templates select="old" />
	<xsl:apply-templates select="new" />
</xsl:template>


<xsl:template match="old">
	<xsl:if test="$changes = 1">
	 	 <br/><small style="color:blue;"></small> <strike>"<xsl:value-of select="." />"</strike>
	 	&#160; <i><small style="color:blue;"> <xsl:value-of select="@editor" />: <xsl:value-of select="@date" /> - <xsl:value-of select="@version" /></small></i>
	</xsl:if>
	<xsl:if test="$changes = 0">
	</xsl:if>
</xsl:template>

<xsl:template match="new">
	<xsl:if test="/root/show_changes = 1">
	 	<br/><small style="color:red;">current:</small> <u>"<xsl:value-of select="." />"</u>
	 	&#160; <i><small style="color:red;"> <xsl:value-of select="@editor" />: <xsl:value-of select="@date" /> - <xsl:value-of select="@version" /></small></i>
	 	<br/>
	</xsl:if>
	<xsl:if test="/root/show_changes = 0">
		<strong><xsl:value-of select="." /></strong>
	</xsl:if>
</xsl:template>

<xsl:template match="/root/language/scripts/addon/main/point/description/br">
	<xsl:copy></xsl:copy>
</xsl:template>

<xsl:template match="/root/language/scripts/addon/main/point/description/u">
	<xsl:copy><xsl:value-of select="." /></xsl:copy>
</xsl:template>



</xsl:stylesheet>

