#ifndef __V2iWRECK_H
#define __V2iWRECK_H
#include "..\..\include\orbitersdk.h"

class V2iWreck:public VESSEL2
{
public:
	// common class operations
	V2iWreck (OBJHANDLE hObj, int fmodel);
	void SetClassCaps(FILEHANDLE cfg);
	void clbkLoadStateEx (FILEHANDLE scn, void *status);
	void clbkSaveState (FILEHANDLE scn);
	void clbkPreStep(double simt, double simdt, double mjd);
	void clbkPostStep(double simt, double simdt, double mjd);
    int clbkConsumeBufferedKey(DWORD key, bool down, char *kstate);

	// Transfered from the originating V2, for flight analysis
	double LatitudeT;   // dg
	double LongitudeT;  // dg

	double Longitude;
	double Latitude;
	double FlightTime;
	double MaxAltitude;
	double ImpactVelocity;
	double RealRange; 
	double RealAzimuth; 
	double MissRange; 
	double MissAzimuth; 
	double MissLateral;
	double MissLongitudal;
	double LatitudeL;
	double LongitudeL;

	// GPS subsystem tracks, also transfered from the originating V2., for visualization.
	int gpsCount;
	double Longitudes[400], Latitudes[400], Elevations[400];
	int TrackStages[400];
	char TrackPoint[250];

	char TargetName[50];
	char FailureString[250];

	// Flight state (landed, inflight1, inflight2) better be done with enum.
	// However, 'landed' should be expposed to V2, and so be it a simple bool for now...
	bool bLanded;


private:
	// additional initialization and flight state vars and functions
	bool bJustDeployed;
	bool bInflight1;
	double TimeInflight1;
    void SetAdditionalConfig();
	void SetPhysicsLanded();
	void SetPhysicsInflight1();
	void SetPhysicsInflight2();

	// blast and smoke - visual imitation
	enum blastState {TOBLAST, BLASTING, TOSMOKE, SMOKING} BlastState;

	// bright blast imitation
	double StopBlastTime;
	THRUSTER_HANDLE BlastEngine;
	PROPELLANT_HANDLE BlastTank;
	void StartBlast();
	void StopBlast();

	// smoking marker
	THRUSTER_HANDLE SmokeEngine;
	PROPELLANT_HANDLE SmokeTank;
	void StartSmoke();

	// debugging
	void DebugSomething();
	int DebugFlag;
	double debLat;
};

#endif