#ifndef __V2i_H
#define __V2i_H
#include "..\..\include\orbitersdk.h"


/* 
	Useful web sites for V2:
http://www.jirzy.webzdarma.cz/indexe.html
http://www.v2rocket.com/
*/


// tuning constants
const VECTOR3 OFS           = {0, 0, 0}; // universal mesh offset
const TIME_VERT = 4;		// vertical takeoff, sec
const RANGE_LOSS_IDEAL = 6100;   // %%% f(range)? calibrate on EQU!    // empirical range loss on air drag
const char sFailures[3][50] = {"Destructed on", "Engine", "Control"};
const char sSubFailuresBreakup[8][50] = {"takeoff", "reentry", "explosion", "shutdown", "low throttle", "yaw", "roll", "pitch"};


class V2i:public VESSEL2
{
public:
	// constructor
	V2i (OBJHANDLE hObj, int fmodel);

	// callbacks
	void clbkSetClassCaps(FILEHANDLE cfg);
	void clbkPostStep(double simt, double simdt, double mjd);
	void clbkLoadStateEx (FILEHANDLE scn, void *status);
	void clbkSaveState (FILEHANDLE scn);
	int clbkConsumeBufferedKey(DWORD key, bool down, char *kstate);

	// launch all V2s around!
	void ExternalLaunch();
private:
	// Target, from scenario
	double LatitudeT;  // dg
	double LongitudeT; // dg
	char TargetName[50];

	// structure
	void SetPhysicsToIdeal();
	void SetPhysicsToRealistic();

	// main engine
	THRUSTER_HANDLE MainEngine;
	THRUSTER_HANDLE MainTH[1];

	// virtual RCS (to simulate vanes/rudders)
	THGROUP_HANDLE LeftRoll;
	THGROUP_HANDLE RightRoll;

	THGROUP_HANDLE LeftYaw;
	THGROUP_HANDLE RightYaw;

	THGROUP_HANDLE LeftYawLower;
	THGROUP_HANDLE RightYawLower;
	THGROUP_HANDLE LeftYawUpper;
	THGROUP_HANDLE RightYawUpper;

	THGROUP_HANDLE LeftYawLowerVane;
	THGROUP_HANDLE RightYawLowerVane;
	THGROUP_HANDLE LeftYawUpperVane;
	THGROUP_HANDLE RightYawUpperVane;

	THGROUP_HANDLE PitchUp;
	THGROUP_HANDLE PitchDown;
	void MakeIdealRCS();
	void MakeRealisticRCS();

	// visual effects
	PSTREAM_HANDLE ContrailExhStream;

	// state flags			// bit indexes when stored/retrieved
	bool bCountdown;		// 2
	bool bRocketLaunched;	// 3

	bool bTimeToLaunch;		// 5
	bool bPoweredFlight;	// 6
	bool bShowingContrail;	// 7

	// option flags 
	bool bAutopilot;		// 9
	bool bRealistic;		// 4

	// initial values from launch
	double Longitude0;  // rad
	double Latitude0;   // rad
	double Radius0;     // m
	double LaunchHeadingIdeal;      // dg
	double LaunchHeadingRealistic;  // dg

	// initial values from scn file
	double ExternalLaunchDelay; // s
	double Range;			    // m

	// running 'global' vars;
	double met;    // s; use it as the only reference to elapsed time, to restore from saved.
	double Altitude;  // m, also used for contrail, do not store in autosave
	double MaxAltitude;  // m, accumulates from current altitude

	// action functions
	void UpdateLaunchCountdown();
	void Launch();
	void Explode(bool bLanded);
	void EngineShutdown();
	void ShutdownControls();
	void UpdateContrail();

	// autopilot 

	void AutopilotIdeal();
	void AutopilotRealistic();

	// attitude
	void TurnAttitudeServos();
	void PitchProgramIdeal();
	void PitchProgramRealistic();
	void YawCorrectionIdeal();
	void YawCorrectionRealistic();
	void RollCorrectionIdeal();
	void RollCorrectionRealistic();

	// do not store these in autosave
	double dSimt;  // for servos time span
	double DesiredPitchServosPos;	// %, -1 to 1
	double ActualPitchServosPos;	// %, -1 to 1
	double DesiredYawUpperServoPos;	// %, -1 to 1
	double DesiredYawLowerServoPos;	// %, -1 to 1
	double ActualYawUpperServoPos;	// %, -1 to 1
	double ActualYawLowerServoPos;	// %, -1 to 1
	double DesiredRollTrimsPos;
	double ActualRollTrimsPos;	

	// range control
	double metMECO; // s

	void CalcMECOTime();
	void UpdateCurrentRangeIdeal();

	// inertial system, used to calculate ideal range
	VECTOR3 rvel0;
	double dCosZs, dSinZs, dCosYs, dSinYs, dCosXs, dSinXs;

	void LocalRot(const VECTOR3 vecGlob, VECTOR3 &vecLoc);
	void InitStartLocalRot();
	void StartLocalRot(const VECTOR3 vecGlob, VECTOR3 &vecLoc);

	// GPS
	double metGps;
	int gpsIndex;
	double Longitudes[400], Latitudes[400], Elevations[400];
	int TrackStages[400];
	void WriteGpsTrackPoint();

	// Failures

	double Reliability; // %
	bool bFail;
	double FailTime;
	enum failType {NONE, BREAKUP, ENGINE, CONTROL} FailType;

	void InitializeFailures();
	bool FailCondition();
	void FailAction();

	double FailDynPressure;
	bool ConditionBreakup();
	void ActionBreakup();

	bool ConditionEngine();
	void ActionEngine();

	bool bYawFailed;
	bool bRollFailed;
	bool bPitchFailed;
	double YawFixed;
	double RollFixed;
	double PitchFixed;

	bool ConditionControls();
	void ActionControls();
	void WriteFailComment();

	char FailureString[256];
	double NumFailParam;
	int FailIdx;
	int SubFailIdx;

	// helper functions
	// rad, rad, rad, rad. rad, rad
	void DistanceAzimuthFromCoordPairRad(double Lat1, double Lon1, double Lat2, double Lon2, double* pDistance, double* pAzimuth);
	// rad, rad, rad, rad. km, dg
	void DistanceAzimuthFromCoordPairKmDg(double Lat1, double Lon1, double Lat2, double Lon2, double* pDistance, double* pAzimuth);
	// rad, rad, rad, rad. rad, rad
	void CoordsFromDistanceAzimuthRad(double Lat1, double Lon1, double Distance, double Azimuth, double* pLat2, double* pLon2);
	// rad, rad, km, dg. rad, rad
	void CoordsFromDistanceAzimuthKmDg(double Lat1, double Lon1, double Distance, double Azimuth, double* pLat2, double* pLon2);
	void DebugSomething();

};



#endif