#include "..\r7_vessel2m_S\vessel2m.h"


	// Constants for virtual after-nuke "attitude control":
// constant nominal omega 
const double OMEGA_NOM = 5*RAD;  
// special value in the control channel to indicate the need to stop
const double STOP_ROT = -10000;
// control channel epsilon for stopping
const double EPS_STOP = 1 * RAD;
// pitch/yaw epsilon to allow roll adjustment
const double EPS_PITCH_YAW = 10 * RAD;

	// Constants for glow effect in the atmosphere
const double Q_GLOW_MIN = 1000;
const double Q_GLOW_MAX = 1000000;


class Warhead: public VESSEL2M
{
public:
	Warhead(OBJHANDLE, int);

	// callbacks
	void clbkSetClassCaps(FILEHANDLE);
	int clbkConsumeBufferedKey(DWORD key, bool down, char *kstate);
	void clbkPostStep(double, double, double);
	void clbkVisualCreated (VISHANDLE vis, int refcount);
	void clbkVisualDestroyed (VISHANDLE vis, int refcount);

	// VESSEL2M overrides
	void clbkSaveState (FILEHANDLE scn);
	void ParseScenarioLineEx(char *line, void *status);
	int GetVesselMessage(IntVesselMessage VM, int Value);
	double GetVesselMessage(DblVesselMessage VM, double Value);
	void FinishConfiguration();
	void Burn();
	void Break();
	void WriteLastKmlEntry();

private:

	VM_PayloadTypes MeAsPayloadType;	//+-- don't save: we always define warhead type from scenario date

	// glow effect
	MESHHANDLE hMesh;				//---
	UINT iMesh;						//+-- initialize to -1 to force CTD without "real" runtime initialization
	VISHANDLE hVisual;				//+--
	MATERIAL* pMatTmpl;				//---
	bool bAlphaNotBlended;			//+--

	// shine effect
	PROPELLANT_HANDLE ShineTank;				//+--
	THRUSTER_HANDLE thShinePl, thShineMn;		//+--

	// nuke
	enum NukeStates {N_NONE, N_INSTALLED, N_ARMED, N_DISTANTIANTING, N_DETONATING, N_DETONATED} NukeState;		//+++
	double Timer;					//+++
	double InitialBlastLevel;		//+-- saved but not really needed...
	double WhiteLevel;				//+++
	double ColorLevel;				//+++
	double ColumnLevel;				//+++
	double CloudLevel;				//+++
	void MoveAway();
	void StartBlast();
	void UpdateBlast();
	void CreateParticleStreams();
	void ModifyWarheadToBlast();

	// turn to nadir
	THRUSTER_HANDLE thUp;			//---
	bool bTurnToNadir;				//+--
	OBJHANDLE hEarth;				//+--
	VECTOR3 ControlLevel;			//---
	void SetThruster();
	void GetNavmodeControls();
	void SetGyroControls();
	void SetControllChannel(double ControlLevel, double &GyroLevel);
	VECTOR3 GetWantedBodyTrackAttitude(OBJHANDLE hBody);
	VECTOR3 GetWantedNavmodeAttiude(int NavMode);
	VECTOR3 GetPitchYawSensorsDeviation(VECTOR3 DirGlobal);
	double GetRollSensorsDeviation(VECTOR3 DirLocal);
	double GetWantedRollFromHorizon();
	void ReplaceControlInputsBySignsWithZero(VECTOR3* V);
	void UpdateStopConditions(VECTOR3* V);
	void UpdateRollCondition(VECTOR3* V);

	// kml, outcome
	double PadLat;			//+++ 4 from rocket, all 4 in RAD
	double PadLon;			//+++ Pad coords not used yet, to be used in reporting... 
	double TargetLat;		//+++				
	double TargetLon;		//+++

	double HitLat;			//---			
	double HitLon;			//---
	double Distance;		//---
	double Azimuth;			//---
	double Radius;			//---

	// outcome
	void ShowHitOrNukeOutcome();
};
