#include	"math.h"
#include	"stdio.h"
#include	"Fairing.h"


r7_fairing::r7_fairing(OBJHANDLE hObj, int fmodel): VESSEL2M(hObj, fmodel)
{
	// VESSEL2M crash parameters
	VvCrash = DRand(5, 30); 
	VhCrash = DRand(20, 30);
	VMaxBlast = DRand(1000, 1); 
	QMax = DRand(20000, 5000);		// nominal < 30 k

	// VESSEL2M wrecks
	WreckIdxs[0] = 11;

	// VESSEL2M override
	bFocusOffByDefault = true;
	bFocus = false;

	// default payload and mesh configurations
	MeshName[0] = 0;
	PayloadType = PAYLOAD_SAT2;
	
	// kml
	kmlPlotColor = KML_CLR_VIOLET;
}


void r7_fairing::clbkSetClassCaps(FILEHANDLE cfg)
{
	// physics and geometry
	SetSize(1.3);
	SetEmptyMass(20);
	SetCrossSections(_V(1.03, 1.03, 0.21));
	SetPMI(_V(0.29, 0.29, 0.15));
	SetCW (0.1, 0.2, 0.4, 0.4);							
	SetRotDrag (_V(1.1, 1.1, 0.1));
	SetLiftCoeffFunc(0);
	SetPitchMomentScale(1e-4);
	SetBankMomentScale(1e-4);
	SetSurfaceFrictionCoeff(1e5, 1e5);
	SetTouchdownPoints (_V( 0, 0, -1), _V( 1, 0.5, 1), _V(-1, 1, 1));
	AddMesh(oapiLoadMeshGlobal("r7_S\\FairingSp2"));
}


void r7_fairing::clbkSaveState(FILEHANDLE scn)
{
	VESSEL2M::clbkSaveState(scn);
	oapiWriteScenario_string (scn, "=========== FAIRING vars", "");

	// custom mesh
	if (MeshName[0] != 0)
		oapiWriteScenario_string (scn, "MESHNAME", MeshName);

	// if we are not attached to rocket, save payload type
	if (!bAttached)
		if (PayloadType != PAYLOAD_SAT2)
			oapiWriteScenario_int (scn, "PL_TYPE", PayloadType);

}


void r7_fairing::ParseScenarioLineEx(char *line, void *status)
{
	if (!strnicmp (line, "MESHNAME", 8))
		sscanf (line+8, "%s", MeshName);

	else if (!strnicmp (line, "PL_TYPE", 7))
		sscanf (line+7, "%d", &PayloadType);

	else 
		VESSEL2M::ParseScenarioLineEx(line, status);
}


void r7_fairing::FinishConfiguration()
{
	LoadPhysicsAndMesh();

	//VESSEL2M stuff
	VESSEL2M::FinishConfiguration();
}


// may be called at least twice, overriding the values
void r7_fairing::LoadPhysicsAndMesh()
{
	ClearMeshes();

	// custom mesh from scenario?
	if (MeshName[0] != 0)
		AddMesh(oapiLoadMeshGlobal(MeshName));

	else if (PayloadType == PAYLOAD_SAT1)
		AddMesh(oapiLoadMeshGlobal("r7_S\\FairingSp1"));
	
	else if (PayloadType == PAYLOAD_SAT3)
		AddMesh(oapiLoadMeshGlobal("r7_S\\FairingSp3"));

	else if (PayloadType == PAYLOAD_POLYOT)
		AddMesh(oapiLoadMeshGlobal("r7_S\\FairingPolyot"));

	else
		AddMesh(oapiLoadMeshGlobal("r7_S\\FairingSp2"));
}


void r7_fairing::clbkPostStep(double simt, double SimDT, double mjd)
{
	// common processing for all VESSEL2M-derived objects
	TimestepForVESSEL2M();
}


int r7_fairing::GetVesselMessage(IntVesselMessage VM, int Value)
{
	if (VM == VM_PAYLOAD_TYPE)
	{
		// overwrite config but only if different
		if (PayloadType != (VM_PayloadTypes)Value)
		{
			PayloadType = (VM_PayloadTypes)Value;
			LoadPhysicsAndMesh();
			return 1;
		}
	}
	
	// unsupported message
	return VESSEL2M::GetVesselMessage(VM, Value);
}




DLLCLBK VESSEL *ovcInit(OBJHANDLE hvessel, int flightmodel)
{
	return new r7_fairing(hvessel, flightmodel);
}

DLLCLBK void ovcExit(VESSEL *vessel)
{
	if (vessel) delete (r7_fairing*) vessel;
}