#include	"math.h"
#include	"orbitersdk.h"
#include	"stdio.h"
#include	"Sputnik1.h"



Sputnik1::Sputnik1(OBJHANDLE hObj, int fmodel): VESSEL2M(hObj, fmodel)
{
	// VESSEL2M crash parameters
	VvCrash = DRand(5, 10);					// 5-15 m/s
	VhCrash = DRand(20, 20);				// 20-40 m/s
	VMaxBlast = DRand(1000, 1);				// 1 km/s
	QMax = DRand(50000, 25000);				// 50k-75k

	// VESSEL2M wrecks
	WreckIdxs[0] = 3;

	// bip-bip sound
	RadioTimer = -1;
	bPlayingSound = false;

	// mission outcome
	strcpy(Outcomes[OC_SUCCESS].OutcomeMessage, "Congratulations! You've just launched the planet's first man-made satellite!");
	strcpy(Outcomes[OC_FAIL].OutcomeMessage, "Mission not accomplished. The satellite has failed to reach the orbit...");
}


void Sputnik1::clbkSetClassCaps(FILEHANDLE cfg)
{
	// physics and geometry
	SetSize(0.580);									// diameter 0.580 m
	SetEmptyMass(83.6);								// mass 83.6 kg
	SetCrossSections(_V(0.264, 0.264, 0.264));		// S=pi*D^2/4. m^2
	SetPMI(_V(0.03, 0.03, 0.03));					// from shipedit
	SetCW (0.5, 1.0, 2.0, 2.0);						// symmetrical
	SetRotDrag (_V(0.5, 0.5, 0.5));					// symmetrical. dOmega = -Omega * q * S i * RD i
	SetSurfaceFrictionCoeff(1e-4, 1e-4);			// dflt: 0.1, 0.5;   F = FC * M * g
	SetTouchdownPoints (_V( 0, 0, -0.8), _V( 0.8, 0.4, 0.8), _V(-0.8, 0.8, 0.8));

	// mesh
	AddMesh(oapiLoadMeshGlobal("r7_S\\Sputnik1"));
}


void Sputnik1::clbkSaveState (FILEHANDLE scn)
{
	// inherited
	VESSEL2M::clbkSaveState(scn);

	// separator 
	oapiWriteScenario_string (scn, "=========== SPUTNIK-1 vars", "");

	if (bPlayingSound)
		oapiWriteScenario_string (scn, "PLAY_SOUND", "");

	if (RadioTimer > 0)
		oapiWriteScenario_float (scn, "RADIO_TIMER", RadioTimer);
}


void Sputnik1::ParseScenarioLineEx(char *line, void *status)
{
	if (!strnicmp (line, "PLAY_SOUND", 10))
		bPlayingSound = true;

	else if (!strnicmp (line, "RADIO_TIMER", 11))
		sscanf (line+11, "%lf", &RadioTimer);

	else 
		VESSEL2M::ParseScenarioLineEx(line, status);
}


void Sputnik1::FinishConfiguration()
{
	if (bPlayingSound)
		StartSound();

	//VESSEL2M stuff
	VESSEL2M::FinishConfiguration();
}


void Sputnik1::clbkPostStep(double simt, double SimDT, double mjd)
{
	// common processing for all VESSEL2M-derived objects
	TimestepForVESSEL2M();

	// maintain radio sound in the loop
	if (bPlayingSound)
		SendVesselWaveToFocused(SND_BIP, LOOP);

	// detect when we get separated from the rocket
	if (bAttached)
	{
		// this indicates our separation from the rocket
		if (GetAttachmentStatus(GetAttachmentHandle(TOPARENT, 0)) == NULL)
		{
			// sound broadcast does not work during focus switch, shoud duplicate here
			PlayVesselWave3(SoundLibID, SND_PYRO);

			// start bip-bip timer
			RadioTimer = 7;

			bAttached = false;

			// update mission criteria
			UpdateOrbitalMissionCriteria();
		}

		return;
	}

	// update radio timer
	if (RadioTimer > 0)
	{
		RadioTimer -= SimDT;
		if (RadioTimer <= 0)
			StartSound();
	}
}


int Sputnik1::clbkConsumeBufferedKey(DWORD key, bool down, char *kstate)
{
	// VESSEL2M stuff
	int result = VESSEL2M::clbkConsumeBufferedKey(key, down, kstate);
	if (result != 0)
		return result;

	// only process keydown events
	if (!down) 
		return 0; 

	// shift combinations are reserved
	if (KEYMOD_SHIFT (kstate)) 
		return 0; 

	// play bip-bip sound
	if (key == OAPI_KEY_B) 
	{
		if (bPlayingSound)
			StopSound();
		else
			StartSound();
	}

	return 0;
}



void Sputnik1::StartSound()
{
	bPlayingSound = true;
	SendVesselWaveToFocused(SND_BIP, LOOP);
}


void Sputnik1::StopSound()
{
	bPlayingSound = false;
	SendVesselWaveToFocused(SND_BIP, SND_STOP);
}


int Sputnik1::GetVesselMessage(IntVesselMessage VM, int Value)
{
	if (VM == VM_PAYLOAD_TYPE)
		return PAYLOAD_SAT1;

	// unsupported message
	return VESSEL2M::GetVesselMessage(VM, Value);
}



// ========================================================================

DLLCLBK VESSEL *ovcInit(OBJHANDLE hvessel, int flightmodel)
{
	return new Sputnik1(hvessel, flightmodel);
}

DLLCLBK void ovcExit(VESSEL *vessel)
{
	if (vessel) delete (Sputnik1*) vessel;
}



