#include "..\MyOrbiterLib_S\MyOrbiterLib.h"

#pragma once



	// ======= Definitions for Wreck only =======

// outside pressure, above which the smoke is allowed
const double  PRESSURE_SMOKE = 10;

const int SND_BLAST_LONG = 18;		// non-nukes
const int SND_BLAST_MEDIUM = 19;



class R7_wreck:public VESSEL2
{
public:
	// === this initial block of vars is shared with Wheck, so it should always stay in sync!!!
	char VesselSignature;			//+--
	bool bFocus;					//+++
	bool bFocusOffByDefault;		//+--
	bool bPermanentlyHidden;		//+--
	// === end of synced block of vars

	// common class operations
	R7_wreck (OBJHANDLE hObj, int fmodel);
	void clbkSaveState (FILEHANDLE scn);
	void clbkLoadStateEx (FILEHANDLE scn, void *status);
	void ParseScenarioLineEx(char *line, void *status);
	void clbkPostCreation (void);
	int clbkConsumeBufferedKey(DWORD key, bool down, char *kstate);
	void clbkPostStep(double simt, double simdt, double mjd);

	// an important flag for runtime creation configuration
	bool bJustDeployed;				//+-- 

	// mesh
	int MeshIdx;					//+++

	// video effects, adjustable from originator
	bool bExplode;					//+--

	// inflight/landed
	bool bFlying;					//+++	(read-write is not for the var itself, see code)

	// sound
	int SoundLibID;					//+--

	// outcome
	boolean bShowOutcome;			//+--
	double OutcomeTimer;			//+--
	OUTCOME_OBJECT Outcome;			//+--


private:

	void FinishConfiguration();
	
	double Timer;					// +-- used for blast OR dust with different timeouts
	void RunTimerEvent();


	// bright blast imitation
	double BlastLevel;				//+--
	void StartBlast();
	void StopBlast();

	// smoking marker
	double SmokeLevel;				//+--
	double Pressure;				//+--
	double Density;					//--- just a placeholder for function
	void StartSmoke();
	void StopSmoke();
	void UpdateSmokeState();

	// dust cloud on touchdown
	double DustLevel;				//+--
	void StartDust();
	void StopDust();

	// land after being inflight
	void Land();

	// duplicate from VESSEL2M
	void SwitchFocus(focus_Dirs FocusDir);
	void ToggleEnableFocus();

	// outcome
	void ShowMissionOutcome();
};
