#include "..\r7_vessel2m_S\vessel2m.h"






// physics, geometry
const	double			MESH_OFF = 7.314;
const	double			EMPTY_MASS = 6100;
// fuel, engines
const	double			TANK_CAPACITY = 86904;
const	double			MAX_MAIN_THRUST = 22950*G;
const	double			MAX_CE_THRUST = 3500*G;
const	double			ISP_MIN = 239*G;
const	double			ISP_MAX = 303*G;
// souyz
const	double			SOYUZ_EMPTY_MASS = 6545;
const	double			SOYUZ_TANK_CAPACITY = 93220;
const	double			SOYUZ_ISP_MIN = 255*G;
const	double			SOYUZ_ISP_MAX = 319*G;
const	double			SOYUZ_MAX_MAIN_THRUST = 22950*G;
const	double			SOYUZ_MAX_CE_THRUST = 3571*G;
// souyz BD
const	double			SOYUZ_BD_EMPTY_MASS = 3784;
const	double			SOYUZ_BD_TANK_CAPACITY = 40629;
const	double			SOYUZ_BD_ISP_MIN = 262*G;
const	double			SOYUZ_BD_ISP_MAX = 330*G;
const	double			SOYUZ_BD_MAX_MAIN_THRUST = 24004*G;
const	double			SOYUZ_BD_MAX_CE_THRUST = 3571*G;
// exhausts
const	double			EX_LEN = 15.0;
const	double			EX_WID = 0.35;
const	double			EX_Z = -5.5;

const	double			EX_CE_LEN = 3;
const	double			EX_CE_WID = 0.14;

// main thrusters location
const		VECTOR3		TH_MAIN[4] = {	{ 0.39,  0.39, -4.1 - MESH_OFF},
										{-0.39,  0.39, -4.1 - MESH_OFF},
										{-0.39, -0.39, -4.1 - MESH_OFF},
										{ 0.39, -0.39, -4.1 - MESH_OFF}	};

const		VECTOR3		TH_MAIN_STREAMS[4] = {	{ 0.39,  0.39, EX_Z - MESH_OFF},
												{-0.39,  0.39, EX_Z - MESH_OFF},
												{-0.39, -0.39, EX_Z - MESH_OFF},
												{ 0.39, -0.39, EX_Z - MESH_OFF}	};

// control engine locations
const		VECTOR3		TH_CE[4] = {	{ 1.1, 0,  -4.85 - MESH_OFF},
										{ 0, 1.1,  -4.85 - MESH_OFF},
										{-1.1, 0,  -4.85 - MESH_OFF},
										{ 0, -1.1, -4.85 - MESH_OFF}	};

// control engine locations with updated Z, for mesh rotations
const		VECTOR3		TH_CEM[4] = {	{ 1.1, 0,  0},
										{ 0, 1.1,  0},
										{-1.1, 0,  0},
										{ 0, -1.1, 0}	};
// control engine rotation axis
const		VECTOR3		CE_AXIS[4] = {	{-1, 0, 0},
										{ 0, 1, 0},
										{-1, 0, 0},
										{ 0, 1, 0}	};

// control engine rotation range, +-45deg
const		double		CE_ANGLE = 90*RAD;	
// control engine max deviation, 45deg
const		double		ANGLE_CE_MAX = CE_ANGLE/2;
// control engine vel, for the range of -1 to +1, 
const		double		CE_VEL = 2; // 1 is equivalent of 45 deg/sec, 2=90deg/s


// blocks B-D
const double BD_OFF_SIDE = 1.52;  // 1.471 - original, 1.52 - a compromise, 1.56 - nominal top connection but body too far sideways
const double BD_OFF_Z = 14.337;

const		double		BD_X[4] = {	BD_OFF_SIDE, 0, -BD_OFF_SIDE, 0 };
const		double		BD_Y[4] = {	0, BD_OFF_SIDE, 0, -BD_OFF_SIDE };
const		VECTOR3		BD_ROTS[4] = {	yplus, xminus, yminus, xplus };
const		VECTOR3		BD_OBJ_POINT = {-0.909, 0.0, 15.14};
			char*		BD_NAMES[4]	=	{	"BLOCK_B", "BLOCK_V", "BLOCK_G", "BLOCK_D"	};

const		double		ANGLE_BLOCKS_MAX = 30*RAD;

// default payload attachment height
const		double	PAY_Z = 22.5 - MESH_OFF;

// payload adapter mesh ref point
const		VECTOR3		ADAPTER_REF = {0, 0, 22.173 - MESH_OFF};

// contrail
const double ALT_CONTRAIL_MIN = 9000;
const double ALT_CONTRAIL_MAX = 30000;

// failures
const double  FAIL_TYPE_COUNT = 3.;
const char sFailures[4][250] = {"", "Engine fire ", "Ignition failure ", "Control failure "};





class BlockA: public VESSEL2M
{
public:
	BlockA(OBJHANDLE, int);

	// callbacks
	void clbkSetClassCaps(FILEHANDLE);
	void clbkNavMode (int mode, bool active);
	void clbkPostStep(double, double, double);
	int clbkConsumeDirectKey(char *);
	int clbkConsumeBufferedKey(DWORD, bool, char *);	

	// VESSEL2M overrides
	void clbkSaveState (FILEHANDLE scn);
	void ParseScenarioLineEx(char *line, void *status);
	void clbkPostCreation();
	void FinishConfiguration ();
	int GetVesselMessage(IntVesselMessage VM, int Value);
	double GetVesselMessage(DblVesselMessage VM, double Value);
	void Break();
	bool  failInitialize();
	bool failUpdate();
	void failActivate();

private:
	// fuels, engines, vents, particles
	PROPELLANT_HANDLE MainTank;			//+--, fuel
	THRUSTER_HANDLE		th_main[4];	
	THRUSTER_HANDLE		th_ctrls[4];	//+--, control thrusters
	THRUSTER_HANDLE		th_vent1;		//+--
	THRUSTER_HANDLE		th_vent2;		//+--
	double ContrailLevel;				//+--
	double PreLaunchVentLevel;			//+--

	// custom meshes. Only use those if attaching a non-VESSEL2M payload (from which configuration can't be determined)
	char AdapterMeshName[255];			//+++
	char BodyMeshName[255];				//+++
	VM_PayloadTypes PayloadType;		//+++

	// blocks B-D
	ATTACHED_OBJECT BlocksBD[4];		//+++
	double OmegaBlocks[4];				//+++ 
	double AngleBlocks[4];				//+++
	void SeparateBlockBD(int idx);

	// attachments
	ATTACHED_OBJECT Payload;			//+++
	ATTACHED_OBJECT Fairing1;			//+++
	ATTACHED_OBJECT Fairing2;			//+++
	enum timer_events {TE_NONE, TE_FAIRING_SEP, TE_PAYLOAD_SEP, TE_VENT_OPEN, TE_VENT_CLOSE, TE_DONE} 
		CurrentTimerEvent,				//++|
		storedCurrentTimerEvent;		//+-+
	double SeparationTimer;				//+++
	void SeparateNextItem();
	void SeparateBlockBD();
	void SeparateFairing();
	void SeparatePayload();
	void VentOpen();
	void VentClose();
	void UpdateSeparationTimer();
	void SetSoyuzMassesFuels();

	// focus
	bool bSwitchFocus;					//+++
	void ToggleSwitchFocus();

	// time phase
	bool bSafed;						//+--
	bool bFirstStage;					//+--
	bool bFirstStageSeparation;			//+--

	// animations
	UINT CERotations[4];				//---
	double CERotationPercents[4];		//+--
	double PitchAngle, Angle1, Angle3;	//---

	// autopilot
	bool bAutopilot;					//+++
	void ToggleAutopilot();
	void SetManualControl();
	void SetAutopilotControl();

	// flying
	VECTOR3 ControlLevel;				//---
	double AllControlLevels;			//---
	void GetManualControls();
	void GetNavmodeControls();
	void KillRot();	
	void SetControlEngineRotations();
	void SyncBlocksBD();

	// running vars
	double SimDt;						//---
	double Alt;							//---
	bool bTrusterOn;					//---
	double NominalMainEngineLevel;		//--- %%%update in manual mode
	OBJHANDLE hLaunchpad;				//---

	// trajectory orbital
	double Apogee;						//+++
	double Perigee;						//+++
	double Inc;							//+++ rad

	// trajectory ballistic
	double Azimuth;						//+++  rad, 
	double Range;						//+++ 
	double RangeAdjustment;				//+++
	double AngRangeFree;				//---
	double PadLat;						//+++
	double PadLon;						//+++
	ELEMENTS OrbEls;					//---
	ORBITPARAM OrbParam;				//---
//	double AltMECO;						//

	//trajectory general
	enum stage_events {SE_NOMINAL, SE_NO_TIME_ACCEL, SE_REDUCED_THRUST, SE_MECO} 
		CurrentStage;					//+-- 
	double Met;							//+++
	OBJHANDLE hEarth;					//+--
	bool bReachingPerigee;				//+--
	double YawSignalNormalizationRange;	//+|| 
	void GetAutopilotControls();
	double GetPitchProg();
	double GetPitchProgBallistic();
	double GetPitchProgOrbital();
	double GetPitchProg3St();

	VECTOR3 GXplus;						//+++
//	MATRIX3 TmLocToLaunch;
	void GetOrientErrors();

	// end of mission					//---
	double FuelMass;
	double FlowRate;
	double FuelTime;
	double ApDist;
	double PeDist;
	double PeArg;
	double CurrRange;
	void UpdateCheckShutdownVars();
	void CheckToReduceThrust();
	void CheckForMECO();
	void CheckReachingPerigee();
	void CheckShutdownConditions();
	void CheckForNoTimeAccel();

	// failures
	enum FAIL_TYPE { F_FIRE, F_IGNITION, F_CONTROL } 
		failType;									//-++
	bool bPitchFailed, bYawFailed, bRollFailed;		//+++
	double YawFixedR, RollFixedR, PitchFixedR;		//+++
	double SavedThrust;								//+++
	void failAbortLaunch();
	void failSetControlFailure();

	// cameras

	// output and debugging
	double dOutp1;						//---
	double dOutp2;						//---
	int iOutp1;							//---
	void DebugSomething();
};

