#include "..\r7_vessel2m_S\vessel2m.h"


// Baikonur's pad 1 coordinates
const double LP_AZM = 90;						// DEG
const double LP_LAT = 45.920276;				// DEG
const double LP_LON = 63.342222;				// DEG

// timer
//const double TMINUS_START = -120;				// T-2min
const double TIMER_NOT_SET = -1000000;			// T-unrealistic
const double TIMER_IGNITION = -12;

// static heihghts
const		double		H_VIEWCENTER_TABLE = 12.2;						// support point height over the table surface, DO NOT CHANGE!
const		double		H_TABLE = 13.45;								
const		double		H_TRENCH = 3.56;								

const		double		H_TD_POINTS = H_VIEWCENTER_TABLE + H_TABLE-H_TRENCH;
const		double		H_RING_TABLE = -0.15;
const		double		H_RING = -H_VIEWCENTER_TABLE - H_RING_TABLE;

// static offsets
const		VECTOR3		TABLE_OFF = {0, -(H_TABLE+H_VIEWCENTER_TABLE), 0};
const		VECTOR3		TRENCH_OFF = {111.3, H_TRENCH-(H_TABLE+H_VIEWCENTER_TABLE) , 16.9};
const		VECTOR3		RING_OFF = {0, -H_VIEWCENTER_TABLE, 0};

const		double		H_SUPPORT = 2.5 + H_RING;
const		double		H_BOOM = H_RING;
const		double		H_CABLE_MAST = 2.2 + H_RING;
const		double		H_FUELING_MAST = 1.7 + H_RING;
const		double		H_PLATFORM = -12.2 + H_RING;
const		double		H_LAUNCHER = -H_VIEWCENTER_TABLE + 4.9;


// four rocket supports, start at 45 deg spread counterclockwise from lower left quadrant as we face north
const		double		R_SUPPORT = 7.5;
const		double		L_SUPPORT = R_SUPPORT * COS45D;
const		VECTOR3		SUPPORT_045_OFS = {-L_SUPPORT, H_SUPPORT, -L_SUPPORT};
const		VECTOR3		SUPPORT_135_OFS = { L_SUPPORT, H_SUPPORT, -L_SUPPORT};
const		VECTOR3		SUPPORT_225_OFS = { L_SUPPORT, H_SUPPORT,  L_SUPPORT};
const		VECTOR3		SUPPORT_315_OFS = {-L_SUPPORT, H_SUPPORT,  L_SUPPORT};

// two access booms
const		double		R_BOOM = 7.5+1.75;
const		VECTOR3		BOOM_270_OFS = {-R_BOOM, H_BOOM, 0};
const		VECTOR3		BOOM_090_OFS = { R_BOOM, H_BOOM, 0};

const		double		R_BOOM_S = 7.5;
const		double		H_BOOM_S = H_BOOM;
const		VECTOR3		BOOM_S_270_OFS = {-R_BOOM_S, H_BOOM_S, 0};
const		VECTOR3		BOOM_S_090_OFS = { R_BOOM_S, H_BOOM_S, 0};

// cable mast
const		double		R_CABLE_MAST = 7.5;
const		VECTOR3		CABLE_MAST_OFS = {0, H_CABLE_MAST, R_CABLE_MAST};

const		double		R_CABLE_MAST_SHORT = 6.75;
const		double		H_CABLE_MAST_SHORT = 1.5 + H_RING;
const		VECTOR3		CABLE_MAST_SHORT_090_OFS = {R_CABLE_MAST_SHORT, H_CABLE_MAST_SHORT, 0};
const		VECTOR3		CABLE_MAST_SHORT_180_OFS = {0, H_CABLE_MAST_SHORT, R_CABLE_MAST_SHORT};

// platform
const		VECTOR3		PLATFORM_OFS = {0, H_PLATFORM, 0};
const		VECTOR3		PLATFORM_SHIFT = {0, 0, 19.25};
const		double		PLATFORM_TRANSL_VEL = 0.1;

// fueling mast
const		double		R_FUELING_MAST = 7.75;
const		VECTOR3		FUELING_MAST_OFS = {0, H_FUELING_MAST, R_FUELING_MAST};

// launcher attacment params
const		VECTOR3		LAUNCHER_OFS = {0, H_LAUNCHER, 0};
const		VECTOR3		LAUNCHER_DIR = {0, 1, 0};

// animations
const double RING_ROT_OMEGA		= 0.02;

const double BOOM_ROT_OMEGA		= 0.04;

const double SUPPORT_ROT_OMEGA	= 0.1;
const double SUPPORT_DROP_OMEGA_START = 0.25;
const double SUPPORT_DROP_OMEGA_INC	= 0.2;

const double CABLE_MAST_ROT_OMEGA	= 0.3;
const double CABLE_MAST_DROP_OMEGA_START = 0.25;
const double CABLE_MAST_DROP_OMEGA_INC	= 0.5;

const double FUELING_MAST_ROT_OMEGA	= 0.3;
const double FUELING_MAST_DROP_OMEGA_START = 1;
const double FUELING_MAST_DROP_OMEGA_INC = 3;

//
const double PropellantMass = 100000;


// lights
const VECTOR3 LT_POS[4] = {	{  107, 30,  72},
							{ -107, 30,  83},
							{  70, 36, -128},
							{ -88, 36, -130}	};
const double LT_AZM[4] = { -125, 125, -35, 25	};
const double LT_ELEV_R = -25 * RAD;
const double LT_D_ELEV_R = 4 * RAD;
const double LT_D_AZM_R = 4 * RAD;
const double LT_LEN = 200;
const double LT_WID = 9;
const double LT_DHOR = 2.5;
const double LT_DVER = 2;
const double LIGHTS_TIMER = 600; //sec, check light conditions every 10 minutes

const double LT_D_ELEV_3ST_R = 6 * RAD;
const double LT_D_AZM_3ST_R = 5 * RAD;
const double LT_WID_3ST = 11;

// beacons
const int BEACON_COUNT = 7;

// targets
struct BAL_TARGETS {
	char NameCamel[50];;
	char NameCaps[50];
	double Lat;
	double Lon;
	double RangeAdjustment;
	double AzimuthAdjustment;
};


	// === panels ===

#define LOADBMP(id) ( (HBITMAP) LoadImage(NULL, id, IMAGE_BITMAP, 0, 0, LR_LOADFROMFILE|LR_CREATEDIBSECTION) )

// numbers
struct NumberControlInfo {
	int offX;
	int offY;
	int* piVar;
	int iVarCache;
	int iMin;
	int iMax;
	int sign;
	bool bDot;
	bool bVisible;
};

struct DoubleValueInfo {
	int offX;
	int offY;
	double* pdVar;
	double dVarCache;
	char Fmt[30];
	char str[30];
	int ints[30];
	int FirstNumCtrlIdx;
	int length;
};

const int NC_W = 24;
const int NC_H = 36;
const int NC_BTN_H = 8;

// ballistic target selector
const int BAL_TGT_OFF_X = 222;
const int BAL_TGT_OFF_Y = 36;

// ballistic target description
const int BAL_DESCR_OFF_X = 340;
const int BAL_DESCR_OFF_Y = 45;
const int BAL_DESCR_W = 400;
const int BAL_DESCR_H = 75;

// ballistic target coordinates
const int BAL_LAT_OFF_X = 26;
const int BAL_LAT_OFF_Y = 129;
const int BAL_LON_OFF_X = 305;
const int BAL_LON_OFF_Y = BAL_LAT_OFF_Y;

// orbital params
const int ORB_PER_OFF_X = 86;
const int ORB_PER_OFF_Y = BAL_LAT_OFF_Y;
const int ORB_APO_OFF_X = 236;
const int ORB_APO_OFF_Y = BAL_LAT_OFF_Y;
const int ORB_INC_OFF_X = 408;
const int ORB_INC_OFF_Y = BAL_LAT_OFF_Y;

// time fields
const int TIME_H_OFF_X = 89;
const int TIME_H_OFF_Y = 352;
const int TIME_MN_OFF_X = TIME_H_OFF_X + (NC_W+2)*3;
const int TIME_MN_OFF_Y = TIME_H_OFF_Y;
const int TIME_S_OFF_X = TIME_MN_OFF_X + (NC_W+2)*3;
const int TIME_S_OFF_Y = TIME_H_OFF_Y;

// indicators
const int IND_W = 36;
const int IND_H = 36;

// target indicator
const int TGT_IND_OFF_X = 39;
const int TGT_IND_OFF_Y = 33;

// time indicator
const int TIME_IND_OFF_X = 38;
const int TIME_IND_OFF_Y = 290;

// strings
const int STR_W = 450;
const int STR_H = 50;
const int STR_OFF_X = 53;
const int TGT_STR_OFF_Y = 200;
const int TIME_STR_OFF_Y = 431;


// main button 
const int BTN_SET_W = 256;
const int BTN_SET_H = 55;

const int BTN_SET_OFF_X = 160;
const int BTN_SET_OFF_Y = 528;



// panel areas

// [0-40]
const int AREAS_NUM = 0;

const int AREA_BAL_TGT = AREAS_NUM + 0;

const int AREA_BAL_TGT_LAT = AREAS_NUM + 1;
const int AREA_BAL_TGT_LON = AREAS_NUM + 11;

const int AREA_ORB_PER = AREAS_NUM + 1;
const int AREA_ORB_APO = AREAS_NUM + 16;
const int AREA_ORB_INC = AREAS_NUM + 21;

const int AREA_TIME_H = AREAS_NUM + 26;
const int AREA_TIME_MN = AREAS_NUM + 28;
const int AREA_TIME_S = AREAS_NUM + 30;
// total: 30+2=32

// [40-80]
const int AREAS_UP = 40;
// [80-120]
const int AREAS_DOWN = 80;

// [120-...]
const int AREAS_OTHER = 120;
const int AREA_TGT_IND		= AREAS_OTHER + 0;
const int AREA_TIME_IND		= AREAS_OTHER + 1;
const int AREA_BTN_SET		= AREAS_OTHER + 2;
const int AREA_TGT_STR		= AREAS_OTHER + 3;
const int AREA_TIME_STR		= AREAS_OTHER + 4;
const int AREA_BAL_DESCR	= AREAS_OTHER + 5;

// sound
const int SND_BUTTON = 19;



class R7_launchpad: public VESSEL2M
{
public:
	// constructor
	R7_launchpad(OBJHANDLE, int);

	// calbacks
	void clbkSetClassCaps(FILEHANDLE);
	int clbkConsumeBufferedKey(DWORD key, bool down, char *kstate);
	int clbkConsumeDirectKey (char *keystate);
	void clbkPostStep(double, double, double);
	void clbkVisualCreated (VISHANDLE vis,int refcount);

	// panels
	bool clbkLoadPanel (int id);
	bool clbkPanelRedrawEvent (int id, int event, SURFHANDLE surf);
	bool clbkPanelMouseEvent (int id, int event, int mx, int my);

	// VESSEL2M overrides
	void clbkSaveState (FILEHANDLE scn);
	void ParseScenarioLineEx(char *line, void *status);
	void FinishConfiguration();
	void clbkPostCreation();
	int GetVesselMessage(IntVesselMessage VM, int Value);
	void Break();


private:
	int ScnYear;						//--- year of the scenario

	// Launcher
	ATTACHED_OBJECT Launcher;			//+++
	TrajectoryTypes TrajectoryType;		//+--

	// running vars
	double SimDt;						//---

	// smokes, flames, engine sounds
	double FlameLevel;					//---
	double SmokeLevelMain;				//---
	double SmokeLevelSides;				//---
	void UpdateSmokes();

	// lights
	PROPELLANT_HANDLE MainTank;			//--- 
	THGROUP_HANDLE thg_lights;
	double LightsTimer;					//+--
	void CreateSpotlights();

	// beacons
	VECTOR3 bcol;
	VECTOR3 BeaconPos[BEACON_COUNT];
	BEACONLIGHTSPEC Beacons[BEACON_COUNT];

	// timer, autopilot
	enum TimerEvents {	TE_NONE,
						TE_TURN_TABLE, 
						TE_PLATFORM_RETRACT, 
						TE_BOOMS_DOWN, 
						TE_VENT_STOP, 
						TE_IGNITION, 
						TE_FUELING_MAST_DROP, 
						TE_CABLE_MAST_DROP, 
						TE_PRELIMINARY, 
						TE_INTERMEDIATE, 
						TE_MAIN, 
						TE_STOP_TIMER}
		LastTE;								//+??
	double Timer;							//+++
	double fabsTimer;						//---
	int iTimerH;							//---
	int iTimerM;							//---
	int iTimerS;							//---
	char strTimer[50];						//---
	double LaunchMJD;						//+++
	double TimerFromMJD();
	void TimeSecondsToStr(double Seconds, char* strTime);
	void UpdateTimer();
	void RunTimerEvent(TimerEvents TE);

	// autopilot
	bool bAutopilot;						//+++
	bool bLaunchSequence;					//+++ supplementary flag to get us through the last 3 seconds of launch sequence if autopilot is off
	void ToggleManualAndAutoplilot();
	void TrySetManualControl();
	void TrySetAutopilotControl();

	// scenario
	bool bScenarioWarning;					//---
	char sScenarioWarning[512];				//---

	// targeting
	VM_PayloadTypes PayloadType;			//+--
	BAL_TARGETS BalTargets[6];				//---
	double TargetLat;						//+++
	double TargetLon;						//+++
	char TargetName[255];					//+++
	double Apogee;							//+++
	double Perigee;							//+++
	double Inc;								//+++
	bool bTrajectoryIsSet;					//+--
	double Azimuth;							//+-- , deg
	double Range;							//---
	OBJHANDLE hEarth;						//+--
	double RangeAdjustment;					//+--
	double AzimuthAdjustment;				//+--
	void InitializeBallisticTargets();
	void VerifyTargeting();
	void VerifyTargetingBallistic(char *Name, double Lat, double Lon);
	void VerifyTargetingOrbital(double perigee, double apogee, double inc);
	void VerifyLaunchTime(double TMinus, double MJD);
	void CalcBallisticAzimuth();
	void CalcAdjustments();
	void GetAdjustments(int n, double Ranges[], double AdjRng[], double AdjAz[]);

	// table
	char TableTopMeshName[100];							//+++

	// ring
	UINT RingMesh;										//--- mesh
	UINT RingRotAnim ;									//--- animation
	MGROUP_ROTATE *RingRot;								//--- ring mgroup
	MGROUP_ROTATE *RingRotBoom090, *RingRotBoom270;		//--- boom on ring mgroup
	MGROUP_ROTATE *RingRotSupport045, *RingRotSupport135, *RingRotSupport225, *RingRotSupport315;	//--- support on ring mgroup
	MGROUP_ROTATE *RingRotCableMast, *RingRotCableMast090, *RingRotCableMast180;
	MGROUP_ROTATE *RingRotFuelingMast;
	double RingRotPercent;								//+++ percent
	int RingTurning;									//+-- 3-pos flag
	bool bRingToAzimuth;								//+--
	double TargetRingRotPercent;

	// booms
	char BoomsMeshName[100];							//+++
	UINT BoomMesh090, BoomMesh270;						//---
	UINT BoomRotAnim;									//---
	MGROUP_ROTATE *BoomRot090, *BoomRot270;				//---
	double BoomRotPercent;								//+++
	int BoomTurning;									//+--
	bool bBoomsTurnDown;								//+--

	// supports
	UINT SupportMesh045, SupportMesh135, SupportMesh225, SupportMesh315;	//--- meshes
	UINT SupportRotAnim;								//---
	MGROUP_ROTATE *SupportRot045, *SupportRot135, *SupportRot225, *SupportRot315; //---
	double SupportRotPercent;							//+++
	double SupportDropOmega;							//+--
	int SupportTurning;									//+--
	bool bSupportFalling;								//+--

	// platform
	UINT PlatformMesh;									//---
	UINT PlatformRingMesh;								//---
	UINT PlatformTranslAnim;							//---
	MGROUP_TRANSLATE *PlatformTransl;					//---
	MGROUP_TRANSLATE *PlatformRingTransl;				//---
	double PlatformTranslPercent;						//+++
	int PlatformTranslating;							//+--
	bool bPlatformRetract;								//+--

	// cable mast
	char CableMastMeshName[100];							//+++
	UINT CableMastMesh;									//---
	UINT CableMastMesh090;								//---
	UINT CableMastMesh180;								//---
	UINT CableMastRotAnim;								//---
	MGROUP_ROTATE *CableMastRot, *CableMastRot090, *CableMastRot180;	//---
	double CableMastRotPercent;							//+++
	double CableMastDropOmega;							//+--
	int CableMastTurning;								//+--
	bool bCableMastFalling;								//+--
	
	// fueling mast
	UINT FuelingMastMesh;								//---
	UINT FuelingMastRotAnim;							//---
	MGROUP_ROTATE *FuelingMastRot;						//---
	double FuelingMastRotPercent;						//+++
	double FuelingMastDropOmega;						//+--
	int FuelingMastTurning;								//+--
	bool bFuelingMastFalling;							//+--

	// animation and mesh functions
	VISHANDLE VisHandle;								//---
	void LoadMeshes();
	void HideShadows();
	void DefineAnimations();

	void RunAnimations();
	void AnimateRing(bool bRingStop = false);
	void SetAllRingAnimations();
	void AnimateRingToAzimuth();
	void AnimateBoom();
	void AnimateBoomsAutoDown();
	void AnimatePlatform();
	void AnimatePlatformAutoRetract();
	void AnimateSupport();
	void AnimateSupportDrop();
	void AnimateCableMast();
	void AnimateCableMastDrop();
	void AnimateFuelingMast();
	void AnimateFuelingMastDrop();

	// panels
	SURFHANDLE surfNumbers, surfNumButtonUp, surfNumButtonDown, surfNumPlus, surfNumMinus,
		surfNumTransparent, surfNumDot, surfIndValid, surfSetValid;
	int PanBalTgtIdx;						//+--
	NumberControlInfo NumInfos[100];
	DoubleValueInfo BalTargetLatInfo, BalTargetLonInfo, OrbPerInfo, OrbApoInfo, OrbIncInfo,
		TimeHInfo, TimeMnInfo, TimeSInfo;
	bool bTargetValid;					//---
	bool bTimeValid;					//---
	char sTimeWarning[256];				//---
	double CachePanTimer;				//---

	void panCreateNumberControl(int InfoIdx);
	void panCreateBalTargetCoordinateControls();
	void panCreateOrbParamControls();
	void panCreateTimeControls();
	void panCreateDoubleValueControls(DoubleValueInfo DInfo);
	void panClickNumberUp(int id);
	void panClickNumberDown(int id);
	void panReevaluatePanel();
	void panRedrawBalTargetCoordinates();
	void panValidateBalTarget();
	void panValidateOrbTarget();
	void panValidateLaunchTime();
	void panSetFlightProgram();

	void GetTargetOrbit();

	// debug
	VECTOR3 VV;											//---
	double tt;											//---
	void DebugSomething();
};









