#include "..\r7_vessel2m_S\vessel2m.h"

// propulsion
const		double		ISP_MIN = 247.6 * G;
const		double		ISP_MAX = 304.2 * G;

// exhausts
const	double			EX_LEN = 15.0;
const	double			EX_WID = 0.35;
const	double			EX_Z = -5.24;

const	double			EX_CE_LEN = 3;
const	double			EX_CE_WID = 0.14;

// main thrusters location
const		VECTOR3		TH_MAIN[4] = {	{ 0.39,  0.39, -3.84}, 
										{-0.39,  0.39, -3.84},
										{-0.39, -0.39, -3.84},
										{ 0.39, -0.39, -3.84}	};

const		VECTOR3		TH_MAIN_STREAMS[4] = {	{ 0.39,  0.39, EX_Z}, 
												{-0.39,  0.39, EX_Z},
												{-0.39, -0.39, EX_Z},
												{ 0.39, -0.39, EX_Z}	};

// control engine locations
const		VECTOR3		TH_CE[2] = {	{1.186,  0.525, -3.9},		
										{1.186, -0.525, -3.9}	};	

const		VECTOR3		TH_CEM[2] = {	{1.186,  0, 0},			
										{1.186,  0, 0}	};		
//
const	double ForceImpuls = 50000;



class BlockBD: public VESSEL2M
{
public:
	BlockBD(OBJHANDLE, int);

	// callbacks
	void clbkSetClassCaps(FILEHANDLE);
	void clbkSaveState(FILEHANDLE);
	void ParseScenarioLineEx(char *line, void *status);
	void clbkPostCreation();
	void clbkPreStep(double, double, double);
	void clbkPostStep(double, double, double);
	int clbkConsumeBufferedKey(DWORD key, bool down, char *kstate);
	int clbkConsumeDirectKey(char *keystate);

	// VESSEL2M overrides
	void FinishConfiguration();
    int GetVesselMessage(IntVesselMessage VM, int Value);
    double GetVesselMessage(DblVesselMessage VM, double Value);
	bool  failInitialize();
	bool failUpdate();
	void failActivate();


private:
	PROPELLANT_HANDLE MainTank;			//---, fuel
	THGROUP_HANDLE		thg_main;		//---
	THRUSTER_HANDLE		th_ctrls[4];	//---, control thrusters
	void SetControlEngineRotations();
	double GetRemainingFuel();

	// mesh
	char BodyMeshName[255];				//+++

	//vent
	THRUSTER_HANDLE		th_vent;	//---
	double SeparationTimer;			//+--

	// done?
	bool bSafed;					//+--

	// animations
	UINT CERotations[2];			//---
	double CERotationPercent;		//+--

	// failures
	double FalloutTimer;			//+??
	bool bFallout;					//+??
	double SavedThrust;				//+++
};


