#include "..\r7_vessel2m_S\vessel2m.h"
#include <vector>

#pragma once   

	// ouptut formatting strings

// file
const char* FileStart = "<?xml version=\"1.0\" encoding=\"UTF-8\"?><kml xmlns=\"http://www.opengis.net/kml/2.2\" xmlns:gx=\"http://www.google.com/kml/ext/2.2\" xmlns:kml=\"http://www.opengis.net/kml/2.2\" xmlns:atom=\"http://www.w3.org/2005/Atom\"><Document>\n";
const char* FileEnd = "</Document></kml>\n";

// folder
const char* FolderStart = "<Folder><name>%s</name>\n";
const char* FolderEnd = "</Folder>\n";

// waypoints
const char* WptGround =   "<Placemark><name>%s</name>%s<LookAt><longitude>%.13f</longitude><latitude>%.13f</latitude><range>0</range><tilt>0</tilt><heading>0</heading></LookAt><styleUrl>#%s</styleUrl><Point><coordinates>%.13f,%.13f,0</coordinates></Point></Placemark>\n";
const char* WptAirborne = "<Placemark><name>%s</name>%s<LookAt><longitude>%.13f</longitude><latitude>%.13f</latitude><range>0</range><tilt>0</tilt><heading>0</heading></LookAt><styleUrl>#%s</styleUrl><Point><extrude>1</extrude><altitudeMode>absolute</altitudeMode><coordinates>%.13f,%.13f,%.13f</coordinates></Point></Placemark>\n";

// waypoint styles
const char* StyleLaunch = "<Style id=\"stLaunch\"><IconStyle><Icon><href>http://maps.google.com/mapfiles/kml/paddle/L.png</href></Icon></IconStyle><ListStyle><ItemIcon><href>http://maps.google.com/mapfiles/kml/paddle/L-lv.png</href></ItemIcon></ListStyle></Style>\n";
const char* StyleTarget = "<Style id=\"stTarget\"><IconStyle><color>ff0000ff</color><Icon><href>http://maps.google.com/mapfiles/kml/shapes/target.png</href></Icon></IconStyle></Style>\n";
const char* StyleWreck = "<Style id=\"stWreck\"><IconStyle><Icon><href>http://maps.google.com/mapfiles/kml/shapes/firedept.png</href></Icon></IconStyle></Style>\n";
const char* StyleSeparation = "<Style id=\"stSeparation\"><IconStyle><color>ff0000ff</color><Icon><href>http://maps.google.com/mapfiles/kml/shapes/placemark_square.png</href></Icon></IconStyle></Style>\n";
const char* StyleFlight = "<Style id=\"stFlight\"><IconStyle><Icon><href>http://maps.google.com/mapfiles/kml/shapes/placemark_circle.png</href></Icon></IconStyle></Style>\n";
const char* StyleNuke = "<Style id=\"stNuke\"><IconStyle><scale>3</scale><Icon><href>http://maps.google.com/mapfiles/kml/shapes/sunny.png</href></Icon></IconStyle></Style>\n";

const char* TrkPlacemarkStart = "<Placemark><name>&lt;span style=&quot;color:%s&quot;&gt;trkpt %d&lt;/span&gt;</name><Style><LineStyle><color>%s</color><width>%d</width></LineStyle></Style><LineString><altitudeMode>absolute</altitudeMode><coordinates>\n";
const char* TrkPlacemark = "%.13f,%.13f,%.1f %.13f,%.13f,%.1f\n";
const char* TrkPlacemarkEnd =  "</coordinates></LineString></Placemark>\n";

const char* GroundLineStart = "<Placemark><name>%s</name><visibility>1</visibility><Style><geomColor>%s</geomColor><geomScale>1</geomScale></Style><LineString><tessellate>1</tessellate><coordinates>\n";
const char* GroundLineEnd = "</coordinates></LineString></Placemark>\n";

const char* TrajectoryDescription = "\n<description>\nTarget\n&amp;nbsp;&amp;nbsp;&amp;nbsp;Range: %.0f km\n&amp;nbsp;&amp;nbsp;&amp;nbsp;Azimuth: %.1f deg\n\nWarhead\n&amp;nbsp;&amp;nbsp;&amp;nbsp;Range: %.0f km\n&amp;nbsp;&amp;nbsp;&amp;nbsp;Azimuth: %.1f deg\n\nMiss: %.1f km\n&amp;nbsp;\n&amp;nbsp;\n</description>\n";

// allow only one kml object in the scenario
static int kmlCount = 0;

// for now, limit kml capacity to 10 vessel objects: pad, 4 sides blocks, central block, fairing, payload - all total to 8
const int COUNT_MAX = 10;

// limit each plot to 5000 dots, should be good for at least one circle around the globe
const int PLOT_MAX = 5000;

const double TIMER_INTERVAL = 1;



// color strings
static const char* strColors[] = {	
	"",								// 0: none
	"#CC0500", "FF0005CC",			// 1: red
	"#CCCCCC", "CCCCCCCC",			// 2: white
	"#0005CC", "FFCC0500",			// 3: blue
	"#FFFF33", "FF33FFFF",	 		// 4: yellow
	"#66FF33", "FF33FF66",			// 5: green
	"#9900CC", "FFCC0099"			// 6: violet
};



struct KML_PLOT{
	kmlPlotColors Color;
	double Lat;
	double Lon;
	double Alt;
	double Time;
//	VECTOR3 GlobalPos;
};


struct kmlVessel{
	OBJHANDLE Handle;
	bool bNoPlotting;
	kmlPlotColors kmlPlotColor;
	std::vector <KML_EVENT>  Events;				// growing list of vessel object events, unlimited
	std::vector <KML_PLOT> Plots;				// growing list of vessel object plot dots, force-limited to PLOT_MAX
	char FolderName[256];						// vessel name, to be also used as kml folder name
	bool bWreck;
};








class kmlWriter: public VESSEL2M
{
public:
	kmlWriter(OBJHANDLE, int);

	// VESSEL2M overrides
	void clbkPostCreation();
	void clbkSaveState(FILEHANDLE scn);
	void ParseScenarioLineEx(char *line, void *status);
	void clbkPostStep(double, double, double);
	int GetVesselMessage(IntVesselMessage VM, int Value);

private:
	double kmlTimer;						//+--
	int idxService;							//+--
	std::vector <kmlVessel> kmlVessels;

	int RegisterVessel(OBJHANDLE Handle);
	int StartPlotting(OBJHANDLE hOrigin);
	int StopPlotting(OBJHANDLE hOrigin);
	void AddPlots();
	int AddEvent(KML_EVENT* pEvent);
	int SetColor(KML_COLOR_STRUCT* pColorStruct);

	// special events, stored for cross-event processing
	KML_EVENT EvLaunch;
	KML_EVENT EvTarget;
	KML_EVENT EvArrive;

	char strDescrTags[1000];

	void Write();											

	void WriteTrajectory(FILE *File, KML_EVENT EvLaunch, KML_EVENT EvTarget, KML_EVENT EvArrive);
	void WriteNukeObjects(FILE *File, KML_EVENT Ev);

	void WriteGroundArc(FILE *File, char* strLabel, double LonFromDeg, double LatFromDeg, double LonToDeg, double LatToDeg, kmlPlotColors Color);
	void WriteCircle(FILE *File, char* strLabel, double LonDeg, double LatDeg, double RadiusKm, kmlPlotColors Color);
};
