#include "..\r7_vessel2m_S\vessel2m.h"


// antennas rotation speed
const double ANTENNA_ROTATION_SPEED = 70*RAD;  // rad/s

// antennas rotation centers
const		VECTOR3		ANTEN01_REF = {0, -0.313, 0.84};
const		VECTOR3		ANTEN02_REF = {0,  0.313, 0.84};

class Sputnik3: public VESSEL2M
{
public:
	Sputnik3(OBJHANDLE, int);

	// callbacks
	void clbkSetClassCaps(FILEHANDLE);
	void clbkPostStep(double, double, double);
	int clbkConsumeBufferedKey(DWORD key, bool down, char *kstate);
	
	// VESSEL2M overrides
	void clbkSaveState (FILEHANDLE scn);
	void ParseScenarioLineEx(char *line, void *status);
	void FinishConfiguration ();
	int GetVesselMessage(IntVesselMessage VM, int Value);

private:
	// radio
	double RadioTimer;			//+++
	bool bPlayingSound;			//+++
	void StartSound();
	void StopSound();

	double SimDt;				//---

	// antenna animation
	double AnimationTimer;		//+++
	double AnimationPercent;	//+++				
	double bAnimate;			//+--
	UINT AntennaRotation;		//---				
	void DefineAnimations();
	void Animate();
	void AnimationStart();
	void AnimationEnd();
};
