#include "..\r7_vessel2m_S\vessel2m.h"

// engine consts
const double ISP = 290*G;
const double TH_BIG = 400*G;

const double RB_X = 0.1;
const double RB_Y = 0.1;
const double RB_Z = -1.5;
const double B_LEN = 1;
const double B_WID = 0.12;
const double FB_XY = 0.5;
const double FB_Z = 0;

const double D_PS = 0.15;
const double FB_XY_PS = FB_XY + D_PS;
const double RB_Z_PS = RB_Z - D_PS;

const VECTOR3 TH_BIG_STREAMS[6] =	{	{ -RB_X,  RB_Y, RB_Z_PS},
										{  RB_X, -RB_Y, RB_Z_PS},
										{  FB_XY_PS, 0, FB_Z},
										{ -FB_XY_PS, 0, FB_Z},
										{  0,  FB_XY_PS, FB_Z},
										{  0, -FB_XY_PS, FB_Z}
									};

const double TH_MED = 16*G;
const double TH_SM = 1*G;

const double RM_XY_L = 0.18;
const double RM_XY_S = 0.038;
const double RM_Z = -1.255;

const double M_LEN = 0.18;
const double M_WID = 0.024;


const double RS_XY_L = 0.16;
const double RS_XY_S = RM_XY_S;
const double RS_Z = RM_Z - 0.0275;

const double S_LEN = 0.018;
const double S_WID = 0.0024;


// constant nominal omega for attitude control
const double OMEGA_NOM = 10*RAD;  
// special value in the control channel to indicate the need to stop
const double STOP_ROT = -10000;
// control channel epsilon for stopping
const double EPS_STOP = 0.1 * RAD; // rad!

// target constants
const double MIN_TGT_DIST = 10000000;	// 10 Mm
const double MIN_LOCK_DIST = 50000;		// 50 km


class Polyot: public VESSEL2M
{
public:
	Polyot(OBJHANDLE, int);

	// callbacks
	void clbkSetClassCaps(FILEHANDLE);
	void clbkPostStep(double, double, double);
	
	// VESSEL2M overrides
	void clbkSaveState (FILEHANDLE scn);
	void ParseScenarioLineEx(char *line, void *status);
	int clbkConsumeBufferedKey(DWORD key, bool down, char *kstate);
	int clbkConsumeDirectKey(char *keystate);
	void clbkNavMode (int mode, bool active);
	int GetVesselMessage(IntVesselMessage VM, int Value);
	void Break();

private:

	// target selection and trackiing
	enum TrackingStates {TS_IDLE, TS_SELECTED, TS_LOCKING, TS_LOCKED, TS_KILLING} 
		TrackingState;						//+??
	OBJHANDLE hCurrTgt;						//+||
	char TargetName[256];					//-++
	double MinDist;							//+||
	VECTOR3 rPos, rPosLoc;					//---
	VECTOR3 rVel, rVelLoc;					//---
	double Dist, Vel, Fuel;					//---

	void SelectNextTarget();
	double GetDistance(OBJHANDLE hVes);
	void LockOnTarget();
	void KillTarget();
	void TurnToTarget();
	void SlideToTarget();
	void ShutDownEngines();
	void MutualDestruction();

	void TargetLost();
	void TargetUnlocked();
	void AbortKilling();
	
	// target params
	void UpdateTargetParams();
	void ShowTargetParams();

	// engine controls
	PROPELLANT_HANDLE MainTank;
	THGROUP_HANDLE thgPitchDown, thgPitchUp, thgYawLeft, thgYawRight, thgRollLeft, thgRollRight;
	THGROUP_HANDLE thgFwd, thgDown, thgUp, thgLeft, thgRight;

	// rotation control subfunctions
	VECTOR3 NavmodeControlLevel;				//---
	VECTOR3 ControlLevel;						//---
	void GetNavmodeControls();
	VECTOR3 GetWantedBodyTrackAttitude(OBJHANDLE hBody);
	VECTOR3 GetPitchYawSensorsDeviation(VECTOR3 DirLocal);
	void UpdateStopConditions(VECTOR3* V);
	void ReplaceControlInputsBySignsWithZero(VECTOR3* V);
	void SetRotationControls();
	void SetControllChannel(double &ControlLevel, double Omega, THGROUP_HANDLE thgNeg, THGROUP_HANDLE thgPos);

	// mission criteria
	bool bMissionHit;					//+++
};
