// ==============================================================
// ORBITER vessel module: N1 Module
// Portions taken from Rob Conley's code:
// GetCPitch()
//
//
// Thanks to:
// Rob Conley (misc functions), 
// Vinka (autopilot)
//
//
// Credits:
// Core module by Manuel Amorim (McDope)
// Guidance algorithm by Richard Croy (rjcroy)
// ==============================================================


//#define OAPI_IMPLEMENTATION

#include "Orbitersdk.h"
#include "resource.h"
#include <iostream>
#include <cstdio>
#include <cmath>

using namespace std;

typedef struct 
{
	HINSTANCE hDLL;
	HFONT font[2];
//	DWORD col[4];
//	HBRUSH brush[5];
	HPEN pen[2];
} GDIParams;

class N1: public VESSEL {
public:
	N1 (OBJHANDLE hObj, int fmodel);
	~N1();

	void TimeStep( double simt );
	void SetClassCaps (VESSEL *vessel, FILEHANDLE cfg);
	void LoadStateEx (VESSEL *vessel, FILEHANDLE scn, void *vs);
	void SaveState (VESSEL *vessel, FILEHANDLE scn);
	
	void InitPanel( int panel );
	void InitialiseGuidance();
	double GetCPitch(double t);
	void Lateral_Guidance(VESSEL *vessel, double SimT, double SimT_Last);
	void Guidance_Routine(VESSEL *vessel, double SimT, double SimT_Last);
	void GetInclinationSP();
//    bool IncInput (void *id, char *str, void *data);
	bool IncInputIn (char *rstr);
	void SetAttControlsFirst(VESSEL *vessel);
	void SetAttControlsSecond(VESSEL *vessel);
	void SetAttControlsThird(VESSEL *vessel);
	void SetAttControlsBlockG(VESSEL *vessel);
	void SetAttControlsBlockD(VESSEL *vessel);
	void SetAttControlsLK(VESSEL *vessel);
	void SetFirstStage (VESSEL *vessel);
	void SetSecondStage (VESSEL *vessel);
	void SetThirdStage (VESSEL *vessel);
	void SetBlockGStage (VESSEL *vessel);
	void SetStackStage (VESSEL *vessel);
	void SetDescentStage (VESSEL *vessel);
	void SetDummyStage (VESSEL *vessel);
	void SeparateStage (VESSEL *vessel, UINT stage);
	void ReleaseSurfaces ();

	const static int nsurf = 1;
	SURFHANDLE srf[1];
	// propellant resources
	PROPELLANT_HANDLE ph_first, ph_second, ph_third, ph_blockg, ph_blockd, ph_lk;	
	THRUSTER_HANDLE th_first[30];               
	THRUSTER_HANDLE th_second[5];            
	THRUSTER_HANDLE th_third[1];    
	THRUSTER_HANDLE th_blockg[1];    
	THRUSTER_HANDLE th_blockd[1];    
	THRUSTER_HANDLE th_lk[1];
	THGROUP_HANDLE thg_first; 
	THGROUP_HANDLE thg_second; 
	THGROUP_HANDLE thg_third; 
	THGROUP_HANDLE thg_blockg; 
	THGROUP_HANDLE thg_blockd; 
	THGROUP_HANDLE thg_lk; 

	double third_stage_isp_vac;
	double third_stage_isp_sl;
	int refcount ;
	MESHHANDLE hN1stg1;
	MESHHANDLE hN1stg2;
	MESHHANDLE hN1stg3;
	MESHHANDLE hN1shroud1;
	MESHHANDLE hN1shroud2;
	MESHHANDLE hN1tower;
	MESHHANDLE hN1blockg;
	MESHHANDLE hN1blockd;
	MESHHANDLE hN1mylk1;
	MESHHANDLE hN1mylk2;
	MESHHANDLE hN1mylok1;
	MESHHANDLE hN1mylok2;
	MESHHANDLE hN1mylok3;

	bool bManualSeparate;
	bool bRadio ;
	double stage_sep;
	UINT stage;
	int status;
	bool Set_First_Stage_Thlevel;
	double First_Stage_Thlevel;
	int	Third_Stage_Propultion;

								// rjcroy Guidance variables

	double INCLINATION ;		// degrees

	bool guidance ;				// guidance switch
	bool Alt_Flag;				// True if max launch altitude reached
	bool MECO_Cond;				// True if MECO conditions met
	bool First_Guidance_Pass ;
	bool T_minus_10;			// True at T minus 10 seconds.
	double Vertical_Vel ; 
	VECTOR3 Airspeed_Vector;
	double Altitude;			// Current vessel altitude
	double Pitch_SP;			// Pitch setpoint
	double Pitch;				// Current vessel pitch
	double Pitch_Error;
	double MET;					// Mission Elasped Time
	double TZero;				// Time Zero - Launch time
	double PC_D ;				// Pitch control coefficient D for d_theta /d_t
	double PC_K;				//    "    "         "       K  "  theta
	double YC_D	;				// Yaw Control
	double YC_K;
	VECTOR3 Angular_Velocity;	// vector x, y, z in rad/s
	double Pitch_Dot;			// Rate of pitch vs time in degree/s
	double Pitch_Error_Dot;		// degrees/s
	double Pitch_Cntrl_Sig;		// Pitch control output signal
	double PC_D_FINAL;			// Pitch control coefficients for final section.
	double PC_K_FINAL; 
	double D_FINAL;				// Vertical velocity control coefficients
	double K_FINAL;
	double ENG_THRST_2;			// Thrust rating of Stage 2 engine. (N)  
	VECTOR3 Surface_Vel;		// surface relative velocity components m/s
	double Vert_Vel_Last;		// vertical velocity in the last time step.
	double SimT_Last;			// Time of last time step
	double Tcorr;				// correction time for QuickSave 
	double Vert_Acc;			// Vertical acceleration
	double Earth_x_Vel;			// velocity of the earths surface at the current latitude (m/s) 
	double i_last;				// value of incliniation in previous iteration.
	ELEMENTS elements;			// Current orbital element of the Soyuz
	double MJD_Time ;			// current time in Modified Julian Date format.
	double Alt_Apoapsis;		// Altitude of apoapsis (km)
	double Alt_Periapsis;		// Altitude of periapsis (km)
	double TC_Error_Dot;		// True course error rate
	double TC_Error_Last ;		// Last true course error.
	OBJHANDLE hVessel;
	OBJHANDLE hEarth;
	char *Planet_Name;
	VECTOR3 Rel_Vel;			// vector of velocities relative to earth
	VECTOR3 Rel_Pos ;			// vector of our position relative to earth
	VECTOR3 h_vector ; 
	VECTOR3 temp;
	double Velocity;
	double a;					// semi-major axis
	double e;					// eccentricity
	double i;					// current inclination
	double h;
	double h_abs;				// magnitude of angular momentum (heading control)
	double V_periapsis;			// Velocity at MECO/periapsis.
	double R_EARTH;				// radius of the earth (m)
	double U_EARTH ;			//( m^3/sec^2)
	double Ob_EARTH  ;			// Obliquity of the Earth (rad)
	double APO_ALT  ;			// Altitude of apoapsis
	double Clairaut_Constant ;
	double Longitude ;			// radians
	double Latitude ;			// radians
	double Radius ;
	double True_Course_SP ;		// true course setpoint (degrees)
	double True_Course ;		// spacecraft true course.
	double True_Course_Err;		// (deg)
	double Error_Course ;		// degrees
	double Heading	;			// radians
	double Heading_SP_Ajd ;		//  heading setpoint adjustment
	double Yaw_Error_Dot ;
	double Yaw_Cntrl_Sig ;
	double i_err;				// error in inclination (degrees)
	double i_dot ;				// change rate of inclination (deg/s)
	double ICF_K;				//  inclination correction factor constant. (3580)
	double ICF ;				// inclination correction factor
	bool DisplayIncSP ;			// toggle for displaying the inclination setpoint.
	bool offDisplayIncSP ;			// switch off for displaying the inclination setpoint.
	double PadHeading ;			// Heading of the Soyuz on the pad (deg)
								// Default heading is for inclination 51.6 deg.
	bool NewIncSP ;				// True if a user has entered a new inclination SP

	bool PostMECO  ;			// switch for cleaning up after MECO
	double TimeMECO;			// Time of MECO
	bool BadHeading ;			// true if soyuz is at an azimuth not suitable for the G&CS
	double TimeMessage;

	// End of rjcroy Guidance variables

	//#define N	11	
	//const double met[N]    = { 0, 30, 45, 60, 75, 90, 110, 140, 200, 250, 400};
	//const double cpitch[N] = {90, 80, 70, 60, 50, 40, 30, 20, 10, 5, 0};
	int N;
	double *met;
	double *cpitch;
	

};


