
#include "Orbitersdk.h"
//#include "C:\Orbiter3\Orbitersdk\samples\SPSDKsample\PanelSDK\PanelSDK.h"
#include <iostream>
#include <fstream>
#include <cstdio>

using namespace std;


const double MAX_ATT_LK				= 2000;
const double THRUST_LK_VAC			= 2050*9.81;
const double THRUST_DOWN_VAC		= 3000*9.81/4.;
//const double THRUST_DOWN_VAC		= 500*9.81/4.;
const double ISP_LK_VAC				= 314*9.81;
const double LK_PROP_MASS			= 5300;
const double DOWN_PROP_MASS			= 20;
const double GEAR_OPERATING_SPEED	= 0.3;
const double GEAR_MAX_ANGLE			= RAD*90.0;

enum GearStatus { GEAR_CLOSED, GEAR_OPEN, GEAR_CLOSING, GEAR_OPENING } gear_status;

class LK: public VESSEL {
public:
	LK (OBJHANDLE hObj, int fmodel);
	~LK();


//	void LoadState (FILEHANDLE scn, void *vs);
//	void SaveState (FILEHANDLE scn);
//	void SetClassCaps();

	void Timestep(double time);		
	void SetClassCaps (VESSEL *vessel, FILEHANDLE cfg);
	void LoadStateEx (VESSEL *vessel, FILEHANDLE scn, void *vs);
	void SaveState (VESSEL *vessel, FILEHANDLE scn);

	void SeparateStage (VESSEL *vessel, UINT stage);
	void SetAscentStage(VESSEL *vessel);
	void SetLKStage(VESSEL *vessel);
	void SetAttControlsLK(VESSEL *vessel);
	void OperateGears ();
	void ActivateGears (GearStatus action);
	void DefineAnimations (VESSEL *vessel);
	
	int ReferenceCount()     { return refcount; };
	MESHHANDLE CMMesh()      { return hCM1; };
	MESHHANDLE LK1Mesh()     { return hLK1; };
	MESHHANDLE LK2Mesh()     { return hLK2; };
	MESHHANDLE LKChuteMesh() { return hLKChute; };

	int refcount;
	MESHHANDLE hLK1;
	MESHHANDLE hLK2;
	MESHHANDLE hCM1;
	MESHHANDLE hLKChute;

	void ManualSeparate( bool d )   { bManualSeparate = d; };
	bool ManualSeparate()			{ return bManualSeparate; };
	


protected:

	bool bManualSeparate;
	double stage_sep;
	UINT stage;
	int status;
	int gear_stat;

	PROPELLANT_HANDLE ph_lk, ph_down;	
	THRUSTER_HANDLE th_lk[1], th_down[4]; 
	THGROUP_HANDLE thg_lk, thg_down; 

	UINT anim_gear;    

	double gear_proc, vgear_proc; 
	bool gear_moving;             
	bool gear_endanim;
	double time;
	
};

