// ==============================================================
// ORBITER module - Laika lunar probe lander
//
// Derived from base class PRVESSEL.
//
// Purpose: soft touchdown on a lunar surface
//
// Features:
// - is deployed 20 meters above the lunar surface, air bags inflated.
// - after landing, air bags deflate, pallets open.
// - supports all features of TProximator class via Proximator member.
// - reacts to excessive structural loads from impacts, collisions and atmospheric dynamic pressure (Q).
//
// Developed by: Andrew Thielmann (igel)
//
// ==============================================================


#include "Proximator.h"


// animation constants
#define ANIM_SPEED_FAST 200
#define ANIM_SPEED_INFLATE_NORMAL 10
#define ANIM_SPEED_DEFLATE_NORMAL 0.1
#define ANIM_SPEED_PALLET_NORMAL 0.1
#define DEFLATE_OPEN_DECR 20		// delay between landing and deflating and opening, sec


enum normal_pallets_status { CLOSED, OPENED }; 
enum normal_pallet_status { P_CLOSED, P_OPENED }; 
enum normal_bags_status { STORED, DEPLOYED };


class LaikaLander: public PRVESSEL {
public:
	LaikaLander (OBJHANDLE hObj, int fmodel);
	~LaikaLander ();
	void LoadState (FILEHANDLE scn, void *vs);
	void SaveState (FILEHANDLE scn);
	void SetClassCaps (FILEHANDLE cfg);
	void Timestep (double simt);
	void SetExtraConfiguration();
	void UpdateLanderPhysics();
	void JustDeployed();

	bool bJustDeployed;

	// animations
	void DefineAnimations();
	void Animate();
	void CheckAfterLandingOperationTime();
	void AirbagsInflateStart(double Speed);
	void AirbagsDeflateStart(double Speed);
	void PalletsOpenStart(double Speed);
	void PalletsCloseStart();

	bool bAnimate;
	enum current_anim {NONE, INFLATING, DEFLATING, OPENING, CLOSING} CurrentAnimation;
	bool bInflateAirbags;
	double dAfterLandingOperationDecr;
	bool bWatingAfterLandingOperation;
	enum normal_bags_status NormalBagsStatus;
	enum normal_pallets_status NormalPalletsStatus;

		// airbags
	enum bags_status { INITIAL, INFLATED, DEFLATED } BagsStatus[4];
	double BagsPercent;
	double AnimSpeedInflate;
	double AnimSpeedDeflate;
	UINT BagAnimations[4];
	bool animateBags[4];
	void AirbagsInflateEnd();
	void AirbagsDeflateEnd();

		//pallets
	enum normal_pallet_status PalletsStatus[3];
	double PalletsPercent;
	double AnimSpeedOpen;
	double AnimSpeedClose;
	UINT PalletAnimations[3];
	bool animatePallets[3];
	void PalletsOpenEnd();
	void PalletsCloseEnd();

	// proximator
	void Burn(OBJHANDLE HTarget);
	void Collide(OBJHANDLE HHit, double Vhit, OBJHANDLE HSwitch); 
	void StartLanding();
	void DoneLanding(OBJHANDLE HTarget, double V, double Vv, double Vh);

	void DestructiveCrash(OBJHANDLE HTarget);
	double dVCollTreshold;
	double dVLandTreshold;
	double dVCrashTreshold;

	TProximator *Proximator;

	void DebugSomething();

private:

};
