// ==============================================================
// ORBITER module - Laika lunar probe fragment
//
// Derived from base class PRVESSEL.
//
// Purpose: impmementation of various Laika lunar carrier / lander fragments resulting from structural breakups
//
// Features:
// - one module represents multiple fragments, each being a separate vessel with different properties
// - supports all features of TProximator class via Proximator member.
// - even being a fragment already, still reacts to excessive structural loads from impacts, collisions and atmospheric dynamic pressure (Q).
//
// Developed by: Andrew Thielmann (igel)
//
// ==============================================================

#include "Proximator.h"

class LaikaFragment: public PRVESSEL {
public:
	LaikaFragment (OBJHANDLE hObj, int fmodel);
	~LaikaFragment ();
	void LoadState (FILEHANDLE scn, void *vs);
	void SaveState (FILEHANDLE scn);
	void SetClassCaps (FILEHANDLE cfg);
	void Timestep (double simt);
	void SetExtraConfiguration();
	void DefineAnimations();
	void JustDeployed();

	bool bJustDeployed;
	enum fragment_id FragmentID;
	char MeshName[256];

	void Burn(OBJHANDLE HTarget);
	void Collide(OBJHANDLE HHit, double Vhit, OBJHANDLE HSwitch); 
	void DoneLanding(OBJHANDLE HTarget, double V, double Vv, double Vh);
	double dVTotalDestructionTreshold;

	TProximator *Proximator;

	void DebugSomething();

private:
};
