#ifndef __r7BlockL_H
#define __r7BlockL_H
#include "..\..\include\orbitersdk.h"




	// tune-up constants 

// mass
const double EMPTY_MASS = 460;
const double FUEL_MASS = 5500;

const double BOZ_MASS = 670;
const double BOZ_FUEL_MASS = 15;
const double BOZ_GAS_MASS = 15;

const double CG_Z = 2.21;
/* 
masses for reference:
	Full with BOZ: 6660
	Full without BOZ: 5960
	Full BOZ: 700
*/

	// engines

// main engine, gimbal
const double THRUST_MAIN = 66600; // N
const double ISP_MAIN = 3330;  

const double MAX_GIMBAL = 5; // deg
const double GIMBAL_VEL = 10; // deg/s
	// location
const double GIMBAL_Z = 1.35; 
	// for stabilisation autopilot
const double OMEGA_MIN = 0; // dg/s
const double OMEGA_MAX = 10; // dg/s

// roll engine, 2-chamber, gimbal
const double THRUST_ROLL = 103; // N
const double ISP_ROLL = 2000; // 
const double MAX_ATT_SENSOR = 10; // deg

const double MAX_GIMBAL_ROLL = 45; // deg
const double GIMBAL_ROLL_VEL = 90; // deg/s
	// location
const double GIMBAL_ROLL_Z = 0.811; 
const double GIMBAL_ROLL_X = 0.551;  
	// exhaust
const double ROLL_EXH_LEN = 0.5;
const double ROLL_EXH_WID = 0.05;
	// for stabilisation autopilot
const double OMEGA_ROLL_MIN = 1; // dg/s
const double OMEGA_ROLL_MAX = 5; // dg/s

// BOZ ullage solid rocket engines, 2
const double THRUST_BOZ_ENGINE = 40 * 9.8; // N
const double ISP_BOZ_ENGINE = 2156; // 
	// location
const double BOZ_Z = 0.25;
const double BOZ_R = 0.75;
const double BOZ_DIR_XY = sin(8*RAD);
const double BOZ_DIR_Z = 1 - 2 * BOZ_DIR_XY;
	// exhaust
const double BOZ_EXH_LEN = 1.0;
const double BOZ_EXH_WID = 0.1;
const double BOZ_EXH_SEP = 0.3;

// BOZ RCS - both types
const double ISP_BOZ_RCS = 70 * 9.8;
// BOZ small engines
const double TH_BOZ_S_ROLL = 1.07 * 9.8; // N
const double TH_BOZ_S = 2.66 * 9.8;      // N
	// location
const double BOZ_S_Z = 0.2;
const double BOZ_S_R = 1.05;
	// exhaust
const double BOZ_S_EXH_LEN = 0.5;
const double BOZ_S_EXH_WID = 0.01;
const double BOZ_S_EXH_SEP = 0.05;
// BOZ large engines
const double TH_BOZ_L_ROLL = 6.54 * 9.8; // N
const double TH_BOZ_L = 11.15 * 9.8;      // N
	// location
const double BOZ_L_Z = 0.25;
const double BOZ_L_R = 1.1;
	// exhaust
const double BOZ_L_EXH_LEN = 1.0;
const double BOZ_L_EXH_WID = 0.03;
const double BOZ_L_EXH_SEP = 0.05;

// payload attachment point
const VECTOR3 PAYPOINT = {0, 0, 2.78};
const VECTOR3 PAYDIR = {0, 0, 1};
const VECTOR3 PAYROT = {1, 0, 0};

// on-screen message lifetime
const double MSG_DISPLAY_TIME = 3;

// for orbit calcs
const double GRAVITYCONTANT = 6.67259e-20*1e9;


// - no initialise/save/restore
// $ to add save/restore
// +++ initialised/saved/restored


class r7BlockL:public VESSEL2
{
public:
	// constructor
	r7BlockL (OBJHANDLE hObj, int fmodel);

	// callbacks
	void clbkSetClassCaps(FILEHANDLE cfg);
    bool clbkLoadGenericCockpit ();
	void clbkPreStep(double simt, double simdt, double mjd);
	void clbkPostStep(double simt, double simdt, double mjd);
	void clbkLoadStateEx (FILEHANDLE scn, void *status);
	void clbkSaveState (FILEHANDLE scn);
	void clbkPostCreation ();
	int clbkConsumeDirectKey (char *keystate);
	int clbkConsumeBufferedKey(DWORD key, bool down, char *kstate);
	void clbkVisualCreated(VISHANDLE, int);
	void clbkVisualDestroyed(VISHANDLE, int);
	void clbkNavMode (int mode, bool active);

private:
	// meshes and visuals
	int MeshID;//-
	VISHANDLE vis;//-

	// cameras
	enum CameraDirs {CAMERA_UP, CAMERA_DOWN, CAMERA_BLOCKI} 
		CameraDir;//++

	void ToggleOnboardCamera(CameraDirs Dir);

	// Target orbit
	enum TargetOrbits {TGT_MOLNIYA, TGT_MOON, TGT_VENUS, TGT_MARS, TGT_CUSTOM} 
		Target;//+++

	// BOZ
	char BOZName[255];//+++
	double BOZMass;//-
	ATTACHMENTHANDLE hForBOZ;//-
	OBJHANDLE hBOZ; //+-

	void AttachBOZ();
	void SeparateBOZ();

	// Payload
	char PayloadName[255];//+++
	double PayloadMass;//-
	ATTACHMENTHANDLE hForPayload;//-
	// these are appachment point params on payload, not on block L
	VECTOR3 PayREF;//+++
	VECTOR3 PayDIR;//+++
	VECTOR3 PayROT;//+++

	void PayloadAttach();
	void PayloadSeparate();

	// state flags, //bit, //+++
	bool bNeedsCoastingInit;//0
	bool bCoasting;//1
	bool bPrograded;//2
	bool bIgniting;//3
	bool bBurning;//4
	bool bDone;//5
	bool bSwitchFocus; //6
	bool bBOZFired;//7
	bool bMEPrelim;//8
	bool bMEInterm;//9
	bool bBOZSeparated;//10
	bool bMEMain;//11
	bool bKickedBOZ;//12
	bool bVerboseCountdown;//13
	bool bManualControl;//14
	bool bEasyMode;//15

	// calculated long-term navigational params, //+++
	double TimeToIgnition;
	double TimeToBOZSeparation;
	double TimeToMECO;
	double BurnLength;
	double TargetApoR;
	double TargetApoRLess;

	void InitializeCoastingPhase();
	void UpdateIgnitingPhase(double simdt);
	void InitializePlatform();
	double CalcTimeToNode();
	double CalcTimeToSouth();
	double CalcTLIBurnTime();

	// main engine
	THRUSTER_HANDLE MainEngine;//-
	THRUSTER_HANDLE MainTH[3];//-
	THGROUP_HANDLE MainThGr;
	PROPELLANT_HANDLE MainTank;//-

	// roll engine
	THRUSTER_HANDLE RollEngine1;//-
	THRUSTER_HANDLE RollEngine2;//-

	// BOZ ullage engine
	PROPELLANT_HANDLE BOZEnginesFuel;
	THGROUP_HANDLE BOZEngines;

	void MakeBOZEngines();
	void RemoveBOZEngines();

	// BOZ RCS
	PROPELLANT_HANDLE BOZRCSTanks;

	void MakeBOZRCSSmall();
	void MakeBOZRCSLarge();
	void RemoveBOZRCSSmall();
	void RemoveBOZRCSLarge();


	// autopilot/manual controls
	void ToggleManualAndAutoplilot();
	void SetAutopilotControl();
	void SetManualControl();
	void GetManualControls();

	// active attitude control

	// running gimbal-time params
	VECTOR3 LocalAtt;//-

	// timestep gimbal actuator positions
    enum EuAngle {EU_PITCH, EU_YAW, EU_ROLL} 
		Channel;//-
	double Pitch;//-
	double Yaw;//-
	double Roll;//-

	void Gimbal(double simdt);
    void GetWantedNavmodeAttiude(int NavMode, VECTOR3 *Angles);
	double GetWantedActuatorPosition(EuAngle Channel, double angle, double omega);
	double GetWantedActuatorPosition1KillRot(EuAngle Channel, double omega);
	double GetPhysicalActuatorPosition(EuAngle Channel, double simdt, double angle, double angle0);

//    double GetWantedActuatorPosition2(double simdt, double angle, double angle0);
//    double GetWantedActuatorPositionRoll2(double simdt, double angle, double angle0);


	// manual control, //-
	enum AttGimbalModes {ATT_NEUT, ATT_POS, ATT_NEG} 
		GimbalDirPitch, GimbalDirYaw;//-
	enum AttRollModes {ATT_R_NEUT, ATT_R_POS, ATT_R_NEG} 
		AttRollMode;//-


	THGROUP_HANDLE LeftRollS;
	THGROUP_HANDLE RightRollS;
	THGROUP_HANDLE LeftYawS;
	THGROUP_HANDLE RightYawS;
	THGROUP_HANDLE PitchUpS;
	THGROUP_HANDLE PitchDownS;

	THGROUP_HANDLE LeftRollL;
	THGROUP_HANDLE RightRollL;
	THGROUP_HANDLE LeftYawL;
	THGROUP_HANDLE RightYawL;
	THGROUP_HANDLE PitchUpL;
	THGROUP_HANDLE PitchDownL;

	// helper function
	void LocalRot(const VECTOR3 vecGlob, VECTOR3 &vecLoc);

	// output
	NOTEHANDLE MessagePort;//- not used yet
	double temp;//-
	double msgStartTime; //-
	bool bMessageDisplayed; //-
	void ShowAnnotationMessage(char *Message);

	void DebugSomething();
};


  // HELPER FUNCTIONS


// produce a random double number from given value of a given span (length)
double DRand(double from, double  span)
{
	return (double)rand() / (double)RAND_MAX * span + from;
}


inline MATRIX3 MakeTranslationMatrix( const VECTOR3 &X, const VECTOR3 &Y,const VECTOR3 &Z )
{
	MATRIX3 TM;

	TM.m11 = X.x;
	TM.m12 = X.y;
	TM.m13 = X.z;
	
	TM.m21 = Y.x;
	TM.m22 = Y.y;
	TM.m23 = Y.z;

	TM.m31 = Z.x;
	TM.m32 = Z.y;
	TM.m33 = Z.z;

	return TM;
}


// eccentricity vector, AKA Laplace vector normalized by Mu
inline VECTOR3 VEccentricity(double Mu, const VECTOR3 VPos, const VECTOR3 VVel)
{
	VECTOR3 VE, VPart1, VPart2, M;
	double Pos;

	M = crossp(VPos, VVel);
	VPart1 = crossp(VVel, M) / Mu;

	Pos = length(VPos);
	VPart2 = VPos / Pos; 

	VE = VPart1 - VPart2;

	return VE;
}


inline double TrueAnomaly(VECTOR3 &VE, VECTOR3 &VPos, VECTOR3 &VVel)
{
	double E = length(VE);
	double Pos = length(VPos);

	double f = acos((VPos.x * VE.x + VPos.y * VE.y + VPos.z * VE.z) / (Pos * E));

	if ( dotp(VPos, VVel) < 0)
		f = 2*PI - f;

	return f;
}


inline double ArgOfPeri(VECTOR3 &VNormal, VECTOR3 &VE)
{
	double Normal = length(VNormal);
	double E = length(VE);

	double omega = acos((VNormal.x * VE.x + VNormal.y * VE.y + VNormal.z * VE.z) / (Normal * E));

	if (VE.z < 0) 
		omega = 2*PI - omega;

	return omega;
}


inline double EccentricAnomaly(double E, double f)
{
	return 2 * atan(sqrt((1-E)/(1+E)) * tan(f/2));
}


inline double MeanAnomaly(double EccentricAnomaly, double E)
{
	return EccentricAnomaly - E * sin(EccentricAnomaly);
}


inline double TimeSincePeriapsis(double MeanAno, double T)
{
	return MeanAno / (2*PI) * T;
}



#endif