#ifndef __Quad_H
#define __Quad_H
#include "..\..\include\orbitersdk.h"


// tune-up constants for autopilot and manual controls

const double FUEL_CAPACITY = 780; 

const double THM_TIME_TRESHOLD_UP = .05;
const double TH_PERCENT_UP_FAST = 4;
const double TH_PERCENT_UP_SLOW = 2;

const double THM_TIME_TRESHOLD_DOWN = .05;
const double TH_PERCENT_DOWN_FAST = 4;
const double TH_PERCENT_DOWN_SLOW = 2;

const double TH_PERCENT_MIN = .2;

const double MAX_VERT_VEL = 20;
const double MAX_N = 1.5;

const double MAX_GIMBAL = 5; // deg
const double GIMBAL_VEL = 180; // deg/s
const double GIMBAL_Z = 0.1; // gimbal mount elevation over CG

const double MESH_Z = 0.3; // mesh shift over CG


class Quad:public VESSEL2
{
public:
	// constructor
	Quad (OBJHANDLE hObj, int fmodel);

	// callbacks
	void clbkSetClassCaps(FILEHANDLE cfg);
	void clbkPreStep(double simt, double simdt, double mjd);
	void clbkPostStep(double simt, double simdt, double mjd);
	void clbkLoadStateEx (FILEHANDLE scn, void *status);
	void clbkSaveState (FILEHANDLE scn);
	int clbkConsumeBufferedKey(DWORD key, bool down, char *kstate);
	int clbkConsumeDirectKey (char *keystate);
	void clbkVisualCreated(VISHANDLE, int);
	void clbkVisualDestroyed(VISHANDLE, int);

private:
	int MeshID;
	VISHANDLE vis;

	// main engine
	enum MainThrottleModes {THM_OFF, THM_UP_FAST, THM_UP_SLOW, THM_DOWN_FAST, THM_DOWN_SLOW, THM_HOVER} 
		MainThrottleManualMode, LastThrottleManualCommand;

	THRUSTER_HANDLE MainEngine;
	THRUSTER_HANDLE MainTH[1];
	PROPELLANT_HANDLE MainTank;
	double MainFuel;
	double ThrottleManualKeyTime;
	double NewMainThrust;

	// attitude controls pitch-yaw
	enum AttGimbalModes {ATT_NEUT, ATT_POS, ATT_NEG} 
		GimbalDirPitch, GimbalDirYaw;
	double Pitch;
	double Yaw;
	void Gimbal();
	VECTOR3 HorizonAtt;
	VECTOR3 GetAttitudeDeltas();

	// roll controls
	enum AttRollModes {ATT_R_NEUT, ATT_R_POS, ATT_R_NEG} 
		AttRollMode;
	double Roll;

	// cameras
	enum CameraDirs {CAMERA_UP, CAMERA_DOWN, CAMERA_FORWARD} 
		CameraDir;

	// virtual RCS (to simulate vanes/rudders)
	THGROUP_HANDLE LeftRoll;
	THGROUP_HANDLE RightRoll;

	void MakeRollRCS();

	// running 'global' vars;
	bool bInFlight;
	double met;    // s; use it as the only reference to elapsed time, to restore from saved.
	double Altitude;  // m, also used for contrail, do not store in autosave
	double MaxAltitude;  // m, accumulates from current altitude
	double Simdt;
	double n;
	double Vv; // vert vel
	double Vh; // hor vel
	double Heading0, Heading, dHeading;
	double Vforw;
	double Vsidew;

	// action functions
	void Launch();

	// inertial system, used to calculate ideal range
	VECTOR3 rpos0;
	VECTOR3 rvel0;
	double Lon0, Lat0, Rad0;
	double Lon, Lat, Rad;

	VECTOR3 GlobalAtt0, GlobalAtt, LocalAtt, LocalAtt0;
	MATRIX3 R0, R0inv;
	double dCosZs, dSinZs, dCosYs, dSinYs, dCosXs, dSinXs;
	VECTOR3 Vs;  

	void LocalRot(const VECTOR3 vecGlob, VECTOR3 &vecLoc);
	void InitStartLocalRot();
	void StartLocalRot(const VECTOR3 vecGlob, VECTOR3 &vecLoc);

	// output
	void DebugSomething();
	void OutputString();

};


// produce a random double number from given value of a given span (length)
double DRand(double from, double  span)
{
	return (double)rand() / (double)RAND_MAX * span + from;
}


#endif